/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.api.card;

import com.google.common.collect.Lists;
import com.pixelmonmod.tcg.api.accessors.Cards;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class Card {
    private String code;
    private int grade;
    private final List<String> tags = Lists.newArrayList();
    private transient ImmutableCard base = null;

    public Card(CompoundNBT nbt) {
        this.load(nbt);
    }

    public Card(PacketBuffer buffer) {
        this.code = ByteBufUtils.getContentDump((ByteBuf)buffer);
        this.grade = buffer.readInt();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.tags.add(ByteBufUtils.getContentDump((ByteBuf)buffer));
        }
    }

    public Card(String code, int grade, String ... tags) {
        this.code = code;
        this.grade = grade;
        this.tags.addAll(Lists.newArrayList((Object[])tags));
    }

    public static Card of(ImmutableCard card) {
        return new Card(card.getCode(), 0, new String[0]);
    }

    public static Card from(ItemStack stack) {
        if (stack.func_77942_o()) {
            return new Card(stack.func_77978_p());
        }
        return null;
    }

    public ImmutableCard getBase() {
        if (this.base == null) {
            this.base = Cards.fromCode(this.code);
        }
        return this.base;
    }

    public boolean is(String ... tags) {
        for (String tag : tags) {
            if (!this.tags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public int getGrade() {
        return this.grade;
    }

    public void load(ItemStack itemStack) {
        this.load(itemStack.func_77978_p());
    }

    public void load(CompoundNBT tag) {
        this.code = tag.func_74779_i("CardCode");
        this.grade = tag.func_74762_e("CardGrade");
        for (INBT nbtBase : tag.func_150295_c("CardTags", 8)) {
            this.tags.add(nbtBase.func_150285_a_());
        }
    }

    public void write(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag == null) {
            tag = new CompoundNBT();
        }
        this.write(tag);
        itemStack.func_77982_d(tag);
    }

    public void write(CompoundNBT tag) {
        tag.func_74778_a("CardCode", this.code);
        tag.func_74768_a("CardGrade", this.grade);
        ListNBT tags = new ListNBT();
        for (String s : this.tags) {
            tags.add((Object)StringNBT.func_229705_a_((String)s));
        }
        tag.func_218657_a("CardTags", (INBT)tags);
    }

    public void write(PacketBuffer buf) {
        ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)this.code);
        buf.writeInt(this.grade);
        buf.writeInt(this.tags.size());
        for (String tag : this.tags) {
            ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)tag);
        }
    }
}

