/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.dimension.ultraspace.tree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class GingkoFancyTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<GingkoFancyTrunkPlacer> CODEC = RecordCodecBuilder.create(p_236891_0_ -> GingkoFancyTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)p_236891_0_).apply((Applicative)p_236891_0_, GingkoFancyTrunkPlacer::new));

    public GingkoFancyTrunkPlacer(int p_i232054_1_, int p_i232054_2_, int p_i232054_3_) {
        super(p_i232054_1_, p_i232054_2_, p_i232054_3_);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TrunkPlacerType.field_236925_f_;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader level, Random random, int height, BlockPos blockPos, Set<BlockPos> logs, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        int j1;
        int i = 5;
        int j = height + 2;
        int k = MathHelper.func_76128_c((double)((double)j * 0.618));
        if (!config.field_227372_q_) {
            GingkoFancyTrunkPlacer.func_236909_a_((IWorldGenerationReader)level, (BlockPos)blockPos.func_177977_b());
        }
        double d0 = 1.0;
        int l = Math.min(3, MathHelper.func_76128_c((double)(1.382 + Math.pow((double)j / 6.0, 3.0))));
        int i1 = blockPos.func_177956_o() + k;
        ArrayList list = Lists.newArrayList();
        list.add(new Foliage(blockPos.func_177981_b(j1), i1));
        for (j1 = j - 5; j1 >= 0; --j1) {
            float f = this.treeShape(j, j1);
            if (f < 0.0f) continue;
            for (int k1 = 0; k1 < l; ++k1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d1 = 1.0;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = blockPos.func_177963_a(d4, (double)(j1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (!this.makeLimb(level, random, blockpos, blockpos1 = blockpos.func_177981_b(5), false, logs, boundingBox, config)) continue;
                int l1 = blockPos.func_177958_n() - blockpos.func_177958_n();
                int i2 = blockPos.func_177952_p() - blockpos.func_177952_p();
                double d6 = (double)blockpos.func_177956_o() - Math.sqrt(l1 * l1 + i2 * i2) * 0.381;
                int j2 = d6 > (double)i1 ? i1 : (int)d6;
                BlockPos blockpos2 = new BlockPos(blockPos.func_177958_n(), j2, blockPos.func_177952_p());
                if (!this.makeLimb(level, random, blockpos2, blockpos, false, logs, boundingBox, config)) continue;
                list.add(new Foliage(blockpos, blockpos2.func_177956_o()));
            }
        }
        this.makeLimb(level, random, blockPos, blockPos.func_177981_b(k), true, logs, boundingBox, config);
        this.makeBranches(level, random, j, blockPos, list, logs, boundingBox, config);
        ArrayList list1 = Lists.newArrayList();
        for (Foliage fancytrunkplacer$foliage : list) {
            list1.add(fancytrunkplacer$foliage.attachment);
        }
        return list1;
    }

    private boolean makeLimb(IWorldGenerationReader level, Random random, BlockPos pos1, BlockPos pos2, boolean force, Set<BlockPos> logs, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        if (!force && Objects.equals(pos1, pos2)) {
            return true;
        }
        BlockPos blockpos = pos2.func_177982_a(-pos1.func_177958_n(), -pos1.func_177956_o(), -pos1.func_177952_p());
        int i = this.getSteps(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = pos1.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (force) {
                GingkoFancyTrunkPlacer.func_236913_a_((IWorldWriter)level, (BlockPos)blockpos1, (BlockState)((BlockState)config.field_227368_m_.func_225574_a_(random, blockpos1).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)this.getLogAxis(pos1, blockpos1))), (MutableBoundingBox)boundingBox);
                logs.add(blockpos1.func_185334_h());
                continue;
            }
            if (TreeFeature.func_236410_c_((IWorldGenerationBaseReader)level, (BlockPos)blockpos1)) continue;
            return false;
        }
        return true;
    }

    private int getSteps(BlockPos p_236888_1_) {
        int i = MathHelper.func_76130_a((int)p_236888_1_.func_177958_n());
        int j = MathHelper.func_76130_a((int)p_236888_1_.func_177956_o());
        int k = MathHelper.func_76130_a((int)p_236888_1_.func_177952_p());
        return Math.max(i, Math.max(j, k));
    }

    private Direction.Axis getLogAxis(BlockPos p_236889_1_, BlockPos p_236889_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_236889_2_.func_177958_n() - p_236889_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_236889_2_.func_177952_p() - p_236889_1_.func_177952_p()));
        if (k > 0) {
            direction$axis = i == k ? Direction.Axis.X : Direction.Axis.Z;
        }
        return direction$axis;
    }

    private boolean trimBranches(int p_236885_1_, int p_236885_2_) {
        return (double)p_236885_2_ >= (double)p_236885_1_ * 0.2;
    }

    private void makeBranches(IWorldGenerationReader level, Random random, int height, BlockPos pos, List<Foliage> foliage, Set<BlockPos> logs, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        for (Foliage fancytrunkplacer$foliage : foliage) {
            int i = fancytrunkplacer$foliage.getBranchBase();
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            if (blockpos.equals((Object)fancytrunkplacer$foliage.attachment.func_236763_a_())) continue;
            this.makeLimb(level, random, blockpos, fancytrunkplacer$foliage.attachment.func_236763_a_(), true, logs, boundingBox, config);
        }
    }

    private float treeShape(int p_236890_1_, int p_236890_2_) {
        if ((float)p_236890_2_ < (float)p_236890_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_236890_1_ / 2.0f;
        float f1 = f - (float)p_236890_2_;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    static class Foliage {
        private final FoliagePlacer.Foliage attachment;
        private final int branchBase;

        public Foliage(BlockPos p_i232055_1_, int p_i232055_2_) {
            this.attachment = new FoliagePlacer.Foliage(p_i232055_1_, 0, false);
            this.branchBase = p_i232055_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

