/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayServerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.RequestExtrasDisplayDataPacket;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;

public class PlayerExtraDataStore {
    private static PixelExtrasData client;
    private static final Map<UUID, PixelExtrasData> playerExtras;

    public static void add(PixelExtrasData data) {
        if (Objects.equals(PlayerExtraDataStore.client.id, data.id)) {
            client.updateServerCosmetics(data.getServerCosmetics());
            return;
        }
        playerExtras.put(data.id, data);
    }

    public static PixelExtrasData get(PlayerEntity player) {
        return PlayerExtraDataStore.get(player.func_110124_au());
    }

    public static PixelExtrasData get(UUID uuid) {
        if (Objects.equals(PlayerExtraDataStore.client.id, uuid)) {
            return client;
        }
        if (!playerExtras.containsKey(uuid)) {
            playerExtras.put(uuid, new PixelExtrasData(uuid));
            NetworkHelper.sendToServer(new RequestExtrasDisplayDataPacket(uuid));
        }
        return playerExtras.get(uuid);
    }

    public static boolean canSeeTexture(PlayerEntity owner, Species species) {
        return owner != null && PlayerExtraDataStore.get(owner).canSeeTexture(species);
    }

    public static void refreshClient(Consumer<PixelExtrasData> consumer) {
        ExtrasContact.updateSelf(client, true, consumer.andThen(data -> PlayerExtraDataStore.saveAndRefresh()));
    }

    public static void saveAndSend() {
        PlayerExtraDataStore.sendDisplayPacket();
        PlayerExtraDataStore.saveClientData();
    }

    public static void saveAndRefresh() {
        PlayerExtraDataStore.saveClientData();
        if (client.isReady() && client.hasData()) {
            PixelExtrasDisplayServerPacket packet = new PixelExtrasDisplayServerPacket(client);
            packet.dataHash = -1;
            NetworkHelper.sendToServer(packet);
        }
    }

    public static void sendDisplayPacket() {
        if (client.isReady() && client.hasData()) {
            NetworkHelper.sendToServer(new PixelExtrasDisplayServerPacket(client));
        }
    }

    public static void loadClientData() {
        File file;
        UUID uuid = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        client = new PixelExtrasData(uuid);
        if (!Pixelmon.isDevEnvironment() && (file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat")).exists()) {
            CompoundNBT compound = new CompoundNBT();
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (compound.func_74764_b(uuid.toString())) {
                CompoundNBT nbt = compound.func_74775_l(uuid.toString());
                ExtrasContact.updateSelf(client, false, newData -> {
                    client = newData;
                    newData.setHatType(PixelExtrasData.HatType.getFromId(nbt.func_74771_c("hatType")));
                    newData.setMonocleType(PixelExtrasData.MonocleType.getFromId(nbt.func_74771_c("monocleType")));
                    if (nbt.func_74764_b("sashType")) {
                        newData.setSashType(PixelExtrasData.SashType.values()[nbt.func_74771_c("sashType")]);
                    }
                    if (nbt.func_74764_b("robeType")) {
                        newData.setRobeType(PixelExtrasData.RobeType.values()[nbt.func_74771_c("robeType")]);
                    }
                    if (nbt.func_74764_b("sphealType")) {
                        newData.setSphealType(PixelExtrasData.SphealType.values()[nbt.func_74771_c("sphealType")]);
                    }
                    for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
                        if (nbt.func_74764_b("en" + category.name().toLowerCase(Locale.ROOT))) {
                            newData.setEnabled(category, nbt.func_74767_n("en" + category.name().toLowerCase(Locale.ROOT)));
                        } else {
                            newData.setEnabled(category, true);
                        }
                        if (!nbt.func_74764_b("c" + category.name().toLowerCase(Locale.ROOT))) continue;
                        newData.setColours(category, nbt.func_74759_k("c" + category.name().toLowerCase(Locale.ROOT)));
                    }
                    PlayerExtraDataStore.saveClientData();
                });
                return;
            }
        }
        ExtrasContact.updateSelf(client, true, newData -> {
            client = newData;
            PlayerExtraDataStore.saveClientData();
        });
    }

    public static void saveClientData() {
        File file = new File(Minecraft.func_71410_x().field_71412_D, "pixel.dat");
        CompoundNBT compound = new CompoundNBT();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            PixelExtrasData.Category[] categoryArray = null;
            try (FileInputStream in = new FileInputStream(file);){
                compound = CompressedStreamTools.func_74796_a((InputStream)in);
            }
            catch (Throwable object) {
                categoryArray = object;
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74774_a("hatType", (byte)PlayerExtraDataStore.client.getHatType().id);
        nbt.func_74774_a("monocleType", (byte)PlayerExtraDataStore.client.getMonocleType().id);
        if (PlayerExtraDataStore.client.sashType != null) {
            nbt.func_74774_a("sashType", (byte)client.getSashType().ordinal());
        }
        if (PlayerExtraDataStore.client.robeType != null) {
            nbt.func_74774_a("robeType", (byte)client.getRobeType().ordinal());
        }
        if (PlayerExtraDataStore.client.sphealType != null) {
            nbt.func_74774_a("sphealType", (byte)client.getSphealType().ordinal());
        }
        for (PixelExtrasData.Category category : PixelExtrasData.Category.values()) {
            nbt.func_74757_a("en" + category.name().toLowerCase(Locale.ROOT), client.isEnabled(category));
            if (client.getColours(category) == null) continue;
            nbt.func_74783_a("c" + category.name().toLowerCase(Locale.ROOT), client.getColours(category));
        }
        compound.func_218657_a(PlayerExtraDataStore.client.id.toString(), (INBT)nbt);
        try (FileOutputStream out = new FileOutputStream(file);){
            CompressedStreamTools.func_74799_a((CompoundNBT)compound, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        playerExtras = new HashMap<UUID, PixelExtrasData>();
    }
}

