/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.spawning;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCondition;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.api.spawning.SpawningTweak;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.FishingCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.GenericTriggerCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.LegendaryCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.PlayerTrackingCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns.RayTraceCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.selection.FlatDistinctAlgorithm;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.spawners.TriggerSpawner;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CurryCheckSpawns;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.blocks.FossilBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.spawning.CaveLevelTweak;
import com.pixelmonmod.pixelmon.spawning.FluteLevelTweak;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.LevelByDistanceEvolutionCondition;
import com.pixelmonmod.pixelmon.spawning.PlayerBasedLevels;
import com.pixelmonmod.pixelmon.spawning.PlayerTrackingSpawner;
import com.pixelmonmod.pixelmon.spawning.SpawnDistanceLevelTweak;
import com.pixelmonmod.pixelmon.spawning.TrackingSpawnerCoordinator;
import com.pixelmonmod.pixelmon.spawning.UltraSpaceAggressionTweak;
import com.pixelmonmod.pixelmon.spawning.UltraSpaceLevelTweak;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;

public class PixelmonSpawning {
    public static SpawnerCoordinator coordinator = null;
    private static final Map<String, SpawnSet> allPerId = new HashMap<String, SpawnSet>();
    private static final Map<String, List<SpawnSet>> all = new HashMap<String, List<SpawnSet>>();
    public static List<SpawnSet> standard = new ArrayList<SpawnSet>();
    public static List<SpawnSet> legendaries = new ArrayList<SpawnSet>();
    public static List<SpawnSet> fishing = new ArrayList<SpawnSet>();
    public static List<SpawnSet> megas = new ArrayList<SpawnSet>();
    public static List<SpawnSet> npcs = new ArrayList<SpawnSet>();
    public static List<SpawnSet> rocksmash = new ArrayList<SpawnSet>();
    public static List<SpawnSet> headbutt = new ArrayList<SpawnSet>();
    public static List<SpawnSet> sweetscent = new ArrayList<SpawnSet>();
    public static List<SpawnSet> curry = new ArrayList<SpawnSet>();
    public static List<SpawnSet> grass = new ArrayList<SpawnSet>();
    public static List<SpawnSet> tallgrass = new ArrayList<SpawnSet>();
    public static List<SpawnSet> seaweed = new ArrayList<SpawnSet>();
    public static List<SpawnSet> caveRock = new ArrayList<SpawnSet>();
    public static List<SpawnSet> forage = new ArrayList<SpawnSet>();
    private static final Map<String, Consumer<SpawnSet>> FEEDERS = new HashMap<String, Consumer<SpawnSet>>();
    public static LegendarySpawner legendarySpawner;
    public static LegendarySpawner megaBossSpawner;
    public static TriggerSpawner fishingSpawner;
    public static TriggerSpawner rocksmashSpawner;
    public static TriggerSpawner headbuttSpawner;
    public static TriggerSpawner sweetscentSpawner;
    public static TriggerSpawner currySpawner;
    public static TriggerSpawner grassSpawner;
    public static TriggerSpawner tallGrassSpawner;
    public static TriggerSpawner seaweedSpawner;
    public static TriggerSpawner caveRockSpawner;
    public static TriggerSpawner forageSpawner;
    public static PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder<PlayerTrackingSpawner> trackingSpawnerPreset;
    public static LegendarySpawner.LegendarySpawnerBuilder<LegendarySpawner> legendarySpawnerPreset;
    public static LegendarySpawner.LegendarySpawnerBuilder<LegendarySpawner> megaBossSpawnerPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> rockSmashPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> headbuttPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> sweetScentPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> curryPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> pixelmonGrassPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> pixelmonDoubleGrassPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> seaweedPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> caverockPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> fishingPreset;
    public static AbstractSpawner.SpawnerBuilder<TriggerSpawner> foragePreset;

    public static void startTrackingSpawner() {
        if (coordinator != null && coordinator.getActive()) {
            coordinator.deactivate();
        }
        if (coordinator == null || !coordinator.getActive()) {
            coordinator = new TrackingSpawnerCoordinator().activate();
        }
    }

    public static void clearSpawning() {
        all.clear();
        allPerId.clear();
        standard.clear();
        legendaries.clear();
        megas.clear();
        npcs.clear();
        fishing.clear();
        rocksmash.clear();
        sweetscent.clear();
        grass.clear();
        tallgrass.clear();
        seaweed.clear();
        caveRock.clear();
        forage.clear();
    }

    public static void loadSpawnSet(SpawnSet set, ResourceLocation rl) {
        String key = rl.func_110623_a().split("/")[0];
        Consumer<SpawnSet> consumer = FEEDERS.get(key);
        if (consumer != null) {
            allPerId.put(set.id, set);
            List current = all.getOrDefault(key, new ArrayList());
            current.add(set);
            all.put(key, current);
            consumer.accept(set);
        }
    }

    public static void initialize() {
        BiConsumer<AbstractSpawner.SpawnerBuilder, SpawningTweak> applyTweak = (builder, tweak) -> {
            if (!CollectionHelper.containsA(builder.tweaks, tweak.getClass())) {
                builder.addTweak((SpawningTweak)tweak);
            }
        };
        BiConsumer<AbstractSpawner.SpawnerBuilder, SpawnerCondition> applyCondition = (builder, condition) -> {
            if (!CollectionHelper.containsA(builder.conditions, condition.getClass())) {
                builder.addCondition((SpawnerCondition)condition);
            }
        };
        List<AbstractSpawner.SpawnerBuilder> presets = Arrays.asList(trackingSpawnerPreset, legendarySpawnerPreset, megaBossSpawnerPreset, rockSmashPreset, headbuttPreset, fishingPreset, sweetScentPreset, seaweedPreset, pixelmonGrassPreset, pixelmonDoubleGrassPreset, caverockPreset, foragePreset);
        if (PixelmonConfigProxy.getSpawning().isSpawnLevelsCloserToPlayerLevels()) {
            PlayerBasedLevels playerBasedLevels = new PlayerBasedLevels();
            presets.forEach(preset -> {
                applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, playerBasedLevels);
                applyCondition.accept((AbstractSpawner.SpawnerBuilder)preset, playerBasedLevels);
            });
        } else {
            presets.forEach(preset -> CollectionHelper.removeAny(preset.tweaks, PlayerBasedLevels.class));
        }
        if (PixelmonConfigProxy.getSpawning().getLevelDistance().isSpawnLevelsByDistance()) {
            SpawnDistanceLevelTweak tweak2 = new SpawnDistanceLevelTweak();
            LevelByDistanceEvolutionCondition condition2 = new LevelByDistanceEvolutionCondition();
            presets.forEach(preset -> {
                applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, tweak2);
                applyCondition.accept((AbstractSpawner.SpawnerBuilder)preset, condition2);
            });
        } else {
            presets.forEach(preset -> {
                CollectionHelper.removeAny(preset.tweaks, SpawnDistanceLevelTweak.class);
                CollectionHelper.removeAny(preset.conditions, LevelByDistanceEvolutionCondition.class);
            });
        }
        if (PixelmonConfigProxy.getSpawning().getLureFluteDuration() > 0) {
            FluteLevelTweak fluteLevelTweak = new FluteLevelTweak();
            presets.forEach(preset -> applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, fluteLevelTweak));
        } else {
            presets.forEach(preset -> CollectionHelper.removeAny(preset.tweaks, FluteLevelTweak.class));
        }
        if (PixelmonConfigProxy.getSpawning().isSpawnLevelsIncreaseInCaves()) {
            presets.forEach(preset -> applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, new CaveLevelTweak()));
        }
        if (PixelmonConfigProxy.getSpawning().isSpawnLevelsIncreaseInCaves()) {
            presets.forEach(preset -> applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, new UltraSpaceLevelTweak()));
        }
        presets.forEach(preset -> applyTweak.accept((AbstractSpawner.SpawnerBuilder)preset, new UltraSpaceAggressionTweak()));
        ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)trackingSpawnerPreset.setSpawnSets(standard)).addSpawnSets(npcs)).setupCache();
        if (PixelmonConfigProxy.getSpawning().isAllowLegendarySpawn()) {
            legendarySpawner = ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)legendarySpawnerPreset.setSpawnFrequency(1200.0f / (float)PixelmonConfigProxy.getSpawning().getLegendarySpawnTicks())).setSpawnSets(legendaries)).setupCache()).apply((LegendarySpawner)new LegendarySpawner("legendary"));
        }
        megaBossSpawner = ((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)megaBossSpawnerPreset.setSpawnFrequency(1200.0f / (float)PixelmonConfigProxy.getSpawning().getBossSpawning().getBossSpawnTicks())).setSpawnSets(megas)).setupCache()).apply((LegendarySpawner)new LegendarySpawner("megaboss"));
        fishingSpawner = ((AbstractSpawner.SpawnerBuilder)fishingPreset.setSpawnSets(fishing)).apply((TriggerSpawner)new TriggerSpawner("fishing"));
        rocksmashSpawner = ((AbstractSpawner.SpawnerBuilder)rockSmashPreset.setSpawnSets(rocksmash)).apply((TriggerSpawner)new TriggerSpawner("rocksmash"));
        headbuttSpawner = ((AbstractSpawner.SpawnerBuilder)headbuttPreset.setSpawnSets(headbutt)).apply((TriggerSpawner)new TriggerSpawner("headbutt"));
        sweetscentSpawner = ((AbstractSpawner.SpawnerBuilder)sweetScentPreset.setSpawnSets(sweetscent)).apply((TriggerSpawner)new TriggerSpawner("sweetscent"));
        currySpawner = ((AbstractSpawner.SpawnerBuilder)curryPreset.setSpawnSets(curry)).apply((TriggerSpawner)new TriggerSpawner("curry"));
        grassSpawner = ((AbstractSpawner.SpawnerBuilder)pixelmonGrassPreset.setSpawnSets(grass)).apply((TriggerSpawner)new TriggerSpawner("grass"));
        tallGrassSpawner = ((AbstractSpawner.SpawnerBuilder)pixelmonDoubleGrassPreset.setSpawnSets(tallgrass)).apply((TriggerSpawner)new TriggerSpawner("tallgrass"));
        seaweedSpawner = ((AbstractSpawner.SpawnerBuilder)seaweedPreset.setSpawnSets(seaweed)).apply((TriggerSpawner)new TriggerSpawner("seaweed"));
        caveRockSpawner = ((AbstractSpawner.SpawnerBuilder)caverockPreset.setSpawnSets(caveRock)).apply((TriggerSpawner)new TriggerSpawner("caverock"));
        forageSpawner = ((AbstractSpawner.SpawnerBuilder)foragePreset.setSpawnSets(forage)).apply((TriggerSpawner)new TriggerSpawner("forage"));
    }

    public static void addRegularSpawners(SpawnerCoordinator coordinator) {
        if (PixelmonConfigProxy.getSpawning().isAllowLegendarySpawn()) {
            coordinator.spawners.add(legendarySpawner);
        }
        coordinator.spawners.add(megaBossSpawner);
        coordinator.spawners.add(fishingSpawner);
        coordinator.spawners.add(caveRockSpawner);
        coordinator.spawners.add(grassSpawner);
        coordinator.spawners.add(headbuttSpawner);
        coordinator.spawners.add(rocksmashSpawner);
        coordinator.spawners.add(seaweedSpawner);
        coordinator.spawners.add(tallGrassSpawner);
        coordinator.spawners.add(sweetscentSpawner);
        coordinator.spawners.add(currySpawner);
        coordinator.spawners.add(forageSpawner);
    }

    public static Map<String, List<SpawnSet>> getAll() {
        return new HashMap<String, List<SpawnSet>>(all);
    }

    static {
        FEEDERS.put("standard", set -> standard.add((SpawnSet)set));
        FEEDERS.put("legendaries", set -> legendaries.add((SpawnSet)set));
        FEEDERS.put("fishing", set -> fishing.add((SpawnSet)set));
        FEEDERS.put("megas", set -> megas.add((SpawnSet)set));
        FEEDERS.put("npcs", set -> npcs.add((SpawnSet)set));
        FEEDERS.put("rocksmash", set -> rocksmash.add((SpawnSet)set));
        FEEDERS.put("headbutt", set -> headbutt.add((SpawnSet)set));
        FEEDERS.put("sweetscent", set -> sweetscent.add((SpawnSet)set));
        FEEDERS.put("curry", set -> curry.add((SpawnSet)set));
        FEEDERS.put("grass", set -> grass.add((SpawnSet)set));
        FEEDERS.put("tallgrass", set -> tallgrass.add((SpawnSet)set));
        FEEDERS.put("seaweed", set -> seaweed.add((SpawnSet)set));
        FEEDERS.put("caverock", set -> caveRock.add((SpawnSet)set));
        FEEDERS.put("forage", set -> forage.add((SpawnSet)set));
        legendarySpawner = null;
        megaBossSpawner = null;
        fishingSpawner = null;
        rocksmashSpawner = null;
        headbuttSpawner = null;
        sweetscentSpawner = null;
        currySpawner = null;
        grassSpawner = null;
        tallGrassSpawner = null;
        seaweedSpawner = null;
        caveRockSpawner = null;
        forageSpawner = null;
        trackingSpawnerPreset = (PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder)new PlayerTrackingSpawner.PlayerTrackingSpawnerBuilder().setCheckSpawns(new PlayerTrackingCheckSpawns());
        legendarySpawnerPreset = (LegendarySpawner.LegendarySpawnerBuilder)((AbstractSpawner.SpawnerBuilder)new LegendarySpawner.LegendarySpawnerBuilder().setSelectionAlgorithm(new FlatDistinctAlgorithm())).setCheckSpawns(new LegendaryCheckSpawns("pixelmon.checkspawns.legendary"));
        megaBossSpawnerPreset = (LegendarySpawner.LegendarySpawnerBuilder)((AbstractSpawner.SpawnerBuilder)((AbstractSpawner.SpawnerBuilder)new LegendarySpawner.LegendarySpawnerBuilder().setFiresChooseEvent(false)).setSelectionAlgorithm(new FlatDistinctAlgorithm())).setCheckSpawns(new LegendaryCheckSpawns("pixelmon.checkspawns.megaboss"));
        rockSmashPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new RayTraceCheckSpawns(LocationType.ROCK_SMASH, state -> {
            if (state.func_185904_a() != Material.field_151576_e || state.func_177230_c() == Blocks.field_150357_h) {
                return false;
            }
            return !(state.func_177230_c() instanceof MultiBlock) && !(state.func_177230_c() instanceof FossilBlock);
        }, "pixelmon.checkspawns.rocksmash"));
        headbuttPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new RayTraceCheckSpawns(LocationType.HEADBUTT, state -> state.func_185904_a() == Material.field_151580_n, "pixelmon.checkspawns.headbutt"));
        sweetScentPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.SWEET_SCENT, "pixelmon.checkspawns.sweetscent"));
        curryPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new CurryCheckSpawns());
        pixelmonGrassPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.GRASS, "pixelmon.checkspawns.grass"));
        pixelmonDoubleGrassPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.DOUBLE_GRASS, "pixelmon.checkspawns.tallgrass"));
        seaweedPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.SEAWEED, "pixelmon.checkspawns.seaweed"));
        caverockPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.CAVE_ROCK, "pixelmon.checkspawns.caverock"));
        fishingPreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new FishingCheckSpawns());
        foragePreset = new AbstractSpawner.SpawnerBuilder().setCheckSpawns(new GenericTriggerCheckSpawns(LocationType.FORAGE, "pixelmon.checkspawns.forage"));
    }
}

