/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.inserters;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.editor.QuestElement;
import com.pixelmonmod.pixelmon.quests.editor.QuestElementType;
import com.pixelmonmod.pixelmon.quests.editor.args.ArgumentType;
import com.pixelmonmod.pixelmon.quests.editor.args.QuestElementArgument;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.quest.ArgsIn;
import com.pixelmonmod.pixelmon.quests.quest.Argument;
import com.pixelmonmod.pixelmon.quests.quest.Arguments;
import com.pixelmonmod.pixelmon.quests.quest.Context;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;

public class InsertIntegerObjective
implements IObjective {
    @Override
    public String identifier() {
        return "INTEGER_INSERTER";
    }

    @Override
    public Arguments parse(Quest quest, Stage stage, ArgsIn args) {
        return Arguments.create(Argument.from(args.get(0), s -> s), Argument.from(args.get(1), s -> {
            if (s.contains("-")) {
                String[] strs = s.split("-");
                return new Range(Integer.parseInt(strs[0]), Integer.parseInt(strs[1]));
            }
            String[] strs = s.split(";");
            int[] ints = new int[strs.length];
            for (int i = 0; i < strs.length; ++i) {
                ints[i] = Integer.parseInt(strs[i]);
            }
            return ints;
        }));
    }

    @Override
    public boolean test(Stage stage, QuestData data, QuestProgress progress, Objective objective, Arguments arguments, Context context) {
        String key = (String)arguments.value(0, progress);
        String testStr = progress.getDataString(key);
        if (testStr != null && !testStr.isEmpty()) {
            return false;
        }
        Object options = arguments.value(1, progress);
        if (options instanceof Range) {
            Range range = (Range)options;
            progress.setData(key, String.valueOf(range.get()));
        } else {
            int[] ints = (int[])options;
            progress.setData(key, String.valueOf(ints[RandomHelper.rand.nextInt(ints.length)]));
        }
        progress.initQuantities();
        progress.sendTo(data.getPlayer());
        return true;
    }

    @Override
    public QuestElement getStructure() {
        return new QuestElement(QuestElementType.OBJECTIVE, this.identifier(), new QuestElementArgument("key", false, false, ArgumentType.TEXT, new String[0]), new QuestElementArgument("values", false, false, ArgumentType.TEXT, new String[0]));
    }

    private static class Range {
        private final int a;
        private final int b;

        public Range(int a, int b) {
            if (a < b) {
                this.a = a;
                this.b = b;
            } else {
                this.b = a;
                this.a = b;
            }
        }

        public int get() {
            int dif = this.b - this.a;
            if (dif <= 0) {
                return this.a;
            }
            return RandomHelper.rand.nextInt(dif) + this.a;
        }
    }
}

