/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.listeners;

import com.pixelmonmod.pixelmon.api.events.ApricornEvent;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ItemListeners {
    @SubscribeEvent
    public void onApricornHarvest(ApricornEvent.Pick event) throws InvalidQuestArgsException {
        if (!(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(false).receive("APRICORN_HARVEST", event.getPickedStack());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickItem event) throws InvalidQuestArgsException {
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == Hand.MAIN_HAND && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(false).receive("ITEM_USE", event.getItemStack());
        }
    }

    @SubscribeEvent
    public void onPickupItem(PlayerEvent.ItemPickupEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(false).receive("ITEM_PICKUP", event.getStack());
        }
    }

    @SubscribeEvent
    public void onDropItem(ItemTossEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(false).receive("ITEM_DROP", event.getEntityItem().func_92059_d());
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(true).receive("ITEM_CRAFT", event.getCrafting());
        }
    }

    @SubscribeEvent
    public void onItemSmelted(PlayerEvent.ItemSmeltedEvent event) throws InvalidQuestArgsException {
        if (event.getPlayer() instanceof ServerPlayerEntity && !(event.getPlayer() instanceof FakePlayer)) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(true).receive("ITEM_SMELT", event.getSmelting());
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws InvalidQuestArgsException {
        if (event.player instanceof ServerPlayerEntity && !(event.player instanceof FakePlayer) && event.player.field_70170_p != null && event.player.field_70170_p.func_82737_E() % 40L == 0L) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.player;
            PlayerInventory inventory = player.field_71071_by;
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            QuestData data = pps.getQuestData(false);
            ArrayList items = new ArrayList(inventory.field_70462_a);
            data.receiveMultipleInternal(new String[]{"ITEM_HAS", "ITEM_HAS_NOT"}, new Object[][]{{items}, {items}}, false);
        }
    }
}

