/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm.editor;

import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.items.QuestEditorItem;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.quests.comm.editor.PullQuestDataPacket;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PushQuestDataPacket
extends AbstractPixelmonPacket {
    private String oldName;
    private Quest quest;
    private boolean delete;
    private boolean openUI;

    public PushQuestDataPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public PushQuestDataPacket(String oldName, Quest quest, boolean openUI) {
        this(oldName, quest, false, openUI);
    }

    public PushQuestDataPacket(String oldName, Quest quest, boolean delete, boolean openUI) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.oldName = oldName;
        this.quest = quest;
        this.delete = delete;
        this.openUI = openUI;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.oldName);
        this.quest.writeToByteBuf(buf);
        buf.writeBoolean(this.delete);
        buf.writeBoolean(this.openUI);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.oldName = buf.func_218666_n();
        this.quest = new Quest(buf);
        this.delete = buf.readBoolean();
        this.openUI = buf.readBoolean();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player == null) {
            return;
        }
        if (QuestEditorItem.checkPermission((PlayerEntity)player)) {
            QuestRegistry.getInstance().deleteQuest(this.quest);
            Quest oldQuest = QuestRegistry.getInstance().getQuest(this.oldName);
            if (oldQuest != null) {
                QuestRegistry.getInstance().deleteQuest(oldQuest);
            }
            if (!this.delete) {
                QuestRegistry.getInstance().createOrUpdateQuest(this.quest);
            }
            NetworkHelper.sendPacket(new PullQuestDataPacket(), player);
            if (this.openUI) {
                OpenScreenPacket.open((PlayerEntity)player, EnumGuiScreen.QuestEditor, new int[0]);
            }
        }
    }
}

