/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.comm;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AbandonQuestPacket
extends AbstractPixelmonPacket {
    private String filename;
    private UUID identifier;

    public AbandonQuestPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AbandonQuestPacket(QuestProgressClient qpc) {
        super(PacketDirection.PLAY_SERVER, true);
        this.filename = qpc.getFilename();
        this.identifier = qpc.getIdentifier();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_180714_a(this.filename);
        buf.func_179252_a(this.identifier);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.filename = buf.func_218666_n();
        this.identifier = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player != null) {
            PlayerPartyStorage pps = StorageProxy.getParty(player);
            pps.getQuestData(true).abandonQuest(this.filename, this.identifier);
        }
    }
}

