/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.KeybindIcon;
import com.pixelmonmod.pixelmon.quests.client.ObjectiveDetail;
import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.StringUtils;

public class GuiKeybindIconQuest
extends KeybindIcon {
    private final KeyBinding keybindA;
    private final KeyBinding keybindB;
    private boolean enabled = true;

    public GuiKeybindIconQuest(KeyBinding keybindA, KeyBinding keybindB) {
        super(null, null);
        this.keybindA = keybindA;
        this.keybindB = keybindB;
    }

    @Override
    public void draw(MatrixStack matrix, int x, int y, float zLevel) {
        if (this.enabled) {
            ResourceLocation rl;
            Minecraft mc = Minecraft.func_71410_x();
            FontRenderer f = Minecraft.func_71410_x().field_71466_p;
            ScreenHelper.drawString(matrix, StringUtils.capitalize((String)this.keybindA.getKey().func_237520_d_().getString()), x + 20, (float)(y + 17), 0xFFFFFF, false, true);
            ScreenHelper.drawString(matrix, StringUtils.capitalize((String)this.keybindB.getKey().func_237520_d_().getString()), x + 20, (float)(y - 5), 0xFFFFFF, false, true);
            boolean drawnArrow = false;
            float[] rgba = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            QuestProgressClient qpc = QuestDataClient.getInstance().getDisplayQuest();
            if (qpc != null && qpc.getObjectives() != null) {
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.enableBlend();
                String name = qpc.getName();
                ScreenHelper.drawStringRightAligned(matrix, name, x - 3, y + 1, 0xFFFFFF, true, true);
                matrix.func_227860_a_();
                matrix.func_227861_a_(-0.5, 0.0, 0.0);
                ScreenHelper.drawStringRightAligned(matrix, name, x - 3, y + 1, 0xFFFFFF, true, true);
                matrix.func_227865_b_();
                if (qpc.getObjectives() != null) {
                    for (ObjectiveDetail od : qpc.getObjectives()) {
                        String detail;
                        if (od.isComplete() || (detail = qpc.format(od)).isEmpty()) continue;
                        ScreenHelper.drawStringRightAligned(matrix, detail, x - 3, y + 9, 0xFFFFFF, false, true);
                        break;
                    }
                }
                ResourceLocation resourceLocation = rl = qpc.isComplete() ? Resources.question_mark : qpc.getIcon().getResource();
                if (qpc.isComplete() || qpc.getColor() == null) {
                    rgba = new float[]{0.8509804f, 0.8509804f, 0.8509804f, 1.0f};
                } else {
                    QuestColor color = qpc.getColor();
                    rgba = new float[]{color.floatR(), color.floatG(), color.floatB(), 1.0f};
                }
                for (QuestMarker marker : qpc.getMarkers()) {
                    if (!this.drawArrow(matrix, marker, x - 1, y + 1, zLevel, rgba)) continue;
                    drawnArrow = true;
                    break;
                }
            } else {
                rl = Resources.exclamation_mark;
                rgba = new float[]{0.8509804f, 0.8509804f, 0.8509804f, 1.0f};
            }
            if (!drawnArrow) {
                ScreenHelper.drawImageQuad(rl, matrix, x - 2, y, 20.0f, 20.0f, 0.0f, 0.0f, 1.0f, 1.0f, rgba[0], rgba[1], rgba[2], rgba[3], 1.0f);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private float getYawFromVec3(Vector3d vec, PlayerEntity player) {
        double dx = vec.field_72450_a;
        double dz = vec.field_72449_c;
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI - 90.0 - (double)player.field_70177_z) + 90.0f;
    }

    private boolean drawArrow(MatrixStack matrix, QuestMarker marker, double x, double y, float z, float[] rgba) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d markerPos = this.getVecForMarker(marker);
        if (markerPos != null) {
            matrix.func_227860_a_();
            Vector3d v1 = new Vector3d(mc.field_71439_g.func_226277_ct_() + 0.5, mc.field_71439_g.func_226278_cu_(), mc.field_71439_g.func_226281_cx_() + 0.5);
            Vector3d v2 = new Vector3d(markerPos.field_72450_a, markerPos.field_72448_b, markerPos.field_72449_c);
            Vector3d v3 = v2.func_178788_d(v1).func_72432_b();
            v3 = new Vector3d(-v3.field_72450_a, v3.field_72448_b, -v3.field_72449_c);
            int arrWidth = 18;
            int arrHeight = 18;
            matrix.func_227861_a_(x + (double)((float)arrWidth / 2.0f), y + (double)((float)arrHeight / 2.0f), 0.0);
            matrix.func_227863_a_(QuaternionHelper.fromEuler(this.getYawFromVec3(v3, (PlayerEntity)mc.field_71439_g) + 180.0f, 0.0f, 0.0f, 1.0f));
            ScreenHelper.drawImage(Resources.arrow, matrix, (float)(-arrWidth) / 2.0f, (float)(-arrHeight) / 2.0f, 18.0f, 18.0f, rgba[0], rgba[1], rgba[2], rgba[3], z);
            matrix.func_227865_b_();
            return true;
        }
        return false;
    }

    private Vector3d getVecForMarker(QuestMarker marker) {
        Minecraft mc = Minecraft.func_71410_x();
        double x = marker.x;
        double y = marker.y;
        double z = marker.z;
        boolean found = false;
        if (marker.uuid != null) {
            for (Entity entity : mc.field_71441_e.func_217416_b()) {
                if (entity == null || !entity.func_110124_au().equals(marker.uuid)) continue;
                x = (double)((float)(entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)mc.func_184121_ak())) + 0.5;
                y = (double)((float)(entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)mc.func_184121_ak()) + entity.func_70047_e()) + 0.8;
                z = (double)((float)(entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)mc.func_184121_ak())) + 0.5;
                found = true;
                break;
            }
        } else {
            found = true;
        }
        if (!found) {
            return null;
        }
        return new Vector3d(x, y, z);
    }
}

