/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.ZygardeCellBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ZygardeCellTileEntity;
import com.pixelmonmod.pixelmon.blocks.ultraspace.LogBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="pixelmon")
public class ZygardeCellsListener {
    private static final boolean DEBUG = false;
    private static final Tags.IOptionalNamedTag<Block> SPAWNABLE_TAG = BlockTags.createOptional((ResourceLocation)new ResourceLocation("pixelmon", "zygarde_spawnable"));
    private static final Direction[] ALL_DIRECTIONS_BUT_UP = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Direction[] DIRECTIONS_LOGS_X = new Direction[]{Direction.DOWN, Direction.WEST, Direction.EAST, Direction.UP};
    private static final Direction[] DIRECTIONS_LOGS_Z = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.UP};
    private static final Direction[] DIRECTIONS_LOGS_Y = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final int HALF_HOUR_IN_TICKS = 36000;
    private static final Set<UUID> hasCube = Sets.newHashSet();

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().func_175149_v()) {
            return;
        }
        if (ZygardeCellsListener.checkForCube(event.getPlayer())) {
            hasCube.add(event.getPlayer().func_110124_au());
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        hasCube.remove(event.getPlayer().func_110124_au());
    }

    public static boolean hasCube(PlayerEntity player) {
        return hasCube.contains(player.func_110124_au());
    }

    public static boolean checkForCube(@Nonnull PlayerEntity player) {
        PlayerInventory inv = player.field_71071_by;
        Predicate<ItemStack> check = itemStack -> itemStack.func_77973_b() == PixelmonItems.zygarde_cube;
        return inv.field_70462_a.stream().anyMatch(check) || inv.field_184439_c.stream().anyMatch(check);
    }

    public static void trySpawnInChunk(ServerPlayerEntity player, Chunk chunk) {
        int x = RandomHelper.getRandomNumberBetween(1, 14);
        int z = RandomHelper.getRandomNumberBetween(1, 14);
        int y = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
        if (!BlockHelper.findAllTileEntityWithinRange(ZygardeCellTileEntity.class, player.field_70170_p, Vector3d.func_237489_a_((Vector3i)chunk.func_76632_l().func_206849_h().func_177982_a(x, y, z)), 72.0, null).isEmpty()) {
            return;
        }
        List<Pair<BlockState, BlockPos>> list = ZygardeCellsListener.scanArea(chunk, x, y, z);
        if (list.isEmpty()) {
            return;
        }
        Collections.shuffle(list);
        for (Pair<BlockState, BlockPos> pair : list) {
            Direction[] directions;
            BlockState state = (BlockState)pair.getKey();
            BlockPos pos = (BlockPos)pair.getValue();
            Direction facing = ZygardeCellsListener.hasAirPocket(chunk, pos, directions = ZygardeCellsListener.getDirectionsForBlock(state));
            if (facing == null) continue;
            ZygardeCellsListener.spawnOn(chunk, pos.func_177972_a(facing), facing.func_176734_d(), player);
            return;
        }
    }

    private static List<Pair<BlockState, BlockPos>> scanArea(Chunk chunk, int x, int y, int z) {
        ArrayList<Pair<BlockState, BlockPos>> list = new ArrayList<Pair<BlockState, BlockPos>>();
        BlockPos.Mutable mPos = new BlockPos.Mutable(x, y, z);
        int startX = mPos.func_177958_n() + 1;
        int startY = mPos.func_177956_o() + 120 - y;
        int startZ = mPos.func_177952_p() + 1;
        int endX = mPos.func_177958_n() - 1;
        int endY = mPos.func_177956_o() - 1;
        int endZ = mPos.func_177952_p() - 1;
        for (int lx = startX; lx >= endX; --lx) {
            for (int ly = startY; ly >= endY; --ly) {
                if (list.size() > 12) {
                    return list;
                }
                for (int lz = startZ; lz >= endZ; --lz) {
                    mPos.func_181079_c(lx, ly, lz);
                    BlockState state = chunk.func_180495_p((BlockPos)mPos);
                    if (!ZygardeCellsListener.canSpawnOn(state)) continue;
                    list.add((Pair<BlockState, BlockPos>)Pair.of((Object)state, (Object)mPos.func_185334_h()));
                }
            }
        }
        return list;
    }

    private static boolean canSpawnOn(BlockState state) {
        if (state.func_196958_f()) {
            return false;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return false;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208515_s) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208515_s)).booleanValue()) {
            return false;
        }
        return state.func_235714_a_(SPAWNABLE_TAG);
    }

    private static Direction[] getDirectionsForBlock(BlockState state) {
        if (state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151577_b || state.func_177230_c() instanceof LeavesBlock || state.func_177230_c() instanceof GrassBlock) {
            return ALL_DIRECTIONS_BUT_UP;
        }
        if (state.func_177230_c() instanceof LogBlock && state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            if (state.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.X) {
                return DIRECTIONS_LOGS_X;
            }
            if (state.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.Z) {
                return DIRECTIONS_LOGS_Z;
            }
            return DIRECTIONS_LOGS_Y;
        }
        return ALL_DIRECTIONS_BUT_UP;
    }

    private static Direction hasAirPocket(Chunk chunk, BlockPos pos, Direction ... facings) {
        ArrayList facingList = Lists.newArrayList();
        for (Direction facing : facings) {
            BlockPos offset = pos.func_177972_a(facing);
            if (!chunk.func_180495_p(offset).func_196958_f()) continue;
            facingList.add(facing);
        }
        return (Direction)RandomHelper.getRandomElementFromList(facingList);
    }

    private static void spawnOn(Chunk chunk, BlockPos pos, Direction facing, ServerPlayerEntity player) {
        Direction rotation = facing.func_176740_k() == Direction.Axis.Y ? Direction.Plane.HORIZONTAL.func_179518_a(RandomHelper.getRandom()) : (RandomHelper.getRandomChance() ? Direction.UP : Direction.DOWN);
        Block block = RandomHelper.getRandomChance(5) ? PixelmonBlocks.zygarde_core : PixelmonBlocks.zygarde_cell;
        BlockState state = (BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)ZygardeCellBlock.ORIENTATION_PROPERTY, (Comparable)facing)).func_206870_a((Property)ZygardeCellBlock.ROTATION_PROPERTY, (Comparable)rotation);
        BlockPos abPos = chunk.func_76632_l().func_206849_h().func_177971_a((Vector3i)pos);
        chunk.func_177412_p().func_175656_a(abPos, state);
    }

    private static /* synthetic */ Style lambda$spawnOn$3(BlockPos abPos, Style it) {
        return it.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + abPos.func_177958_n() + " " + abPos.func_177956_o() + " " + abPos.func_177952_p()));
    }

    static {
        Scheduling.schedule(100, task -> {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            hasCube.clear();
            if (server != null && server.func_71278_l()) {
                for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                    if (player.func_175149_v()) {
                        return;
                    }
                    if (!ZygardeCellsListener.checkForCube((PlayerEntity)player)) continue;
                    hasCube.add(player.func_110124_au());
                }
            }
        }, true);
        Scheduling.schedule(200, task -> {
            if (!PixelmonConfigProxy.getSpawning().isSpawnZygardeCells()) {
                return;
            }
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null && server.func_71278_l()) {
                if (hasCube.isEmpty()) {
                    return;
                }
                UUID random = RandomHelper.getRandomElementFromList(hasCube);
                ServerPlayerEntity player = server.func_184103_al().func_177451_a(random);
                if (player.func_175149_v()) {
                    return;
                }
                ArrayList chunks = Lists.newArrayList();
                int distance = server.func_184103_al().func_72395_o();
                int x1 = player.field_70176_ah + distance;
                int z1 = player.field_70164_aj + distance;
                int x2 = player.field_70176_ah - distance;
                int z2 = player.field_70164_aj - distance;
                for (int x = x1; x >= x2; --x) {
                    for (int z = z1; z >= z2; --z) {
                        Chunk chunk;
                        if (x >= player.field_70176_ah - 1 && x <= player.field_70176_ah + 1 && z >= player.field_70164_aj - 1 && z <= player.field_70164_aj + 1 || (chunk = player.func_71121_q().func_72863_F().func_225313_a(x, z)) == null || chunk.func_177416_w() >= 36000L) continue;
                        chunks.add(chunk);
                    }
                }
                if (!chunks.isEmpty()) {
                    ZygardeCellsListener.trySpawnInChunk(player, (Chunk)RandomHelper.getRandomElementFromList(chunks));
                }
            }
        }, true);
    }
}

