/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items.armor.armoreffects;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItemTiers;
import com.pixelmonmod.pixelmon.items.armor.GenericArmor;
import com.pixelmonmod.pixelmon.items.armor.armoreffects.IArmorEffect;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pixelmon")
public class ThunderstoneEffect
implements IArmorEffect {
    private static final UUID thunderStoneBoostUUID = UUID.fromString("de4f0383-fcf9-4ba7-8ffc-0767c1ead7b9");
    private static final AttributeModifier SpeedModifier2x = new AttributeModifier(thunderStoneBoostUUID, Attributes.field_233821_d_.func_233754_c_(), 1.0, AttributeModifier.Operation.MULTIPLY_BASE);

    @SubscribeEvent
    public static void onArmorChange(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            HashMultimap map = HashMultimap.create();
            map.put((Object)Attributes.field_233821_d_, (Object)SpeedModifier2x);
            if (IArmorEffect.isWearingFullSet(player, PixelmonItemTiers.THUNDERSTONE_ARMOR)) {
                player.func_233645_dx_().func_233793_b_((Multimap)map);
            } else {
                player.func_233645_dx_().func_233785_a_((Multimap)map);
            }
        }
    }

    @Override
    public void onArmorTick(World world, PlayerEntity player, ItemStack stack, GenericArmor armor) {
        if (world.field_72995_K) {
            return;
        }
        if (IArmorEffect.isWearingFullSet(player, armor.field_200882_e) && player.field_70173_aa % 20 == 1) {
            player.func_195064_c(new EffectInstance(Effects.field_76422_e, 40, 1, true, true));
        }
    }
}

