/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.blocks.BerrySaplingBlock;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WailmerPailItem
extends PixelmonItem {
    public WailmerPailItem() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78040_i).func_200918_c(32));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        Direction side = context.func_196000_l();
        World world = context.func_195991_k();
        if (!player.func_175151_a(pos, side, player.func_184586_b(hand))) {
            return ActionResultType.FAIL;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BerrySaplingBlock) {
            IGrowable tree = (IGrowable)state.func_177230_c();
            if (tree.func_176473_a((IBlockReader)world, pos, state, world.field_72995_K)) {
                tree.func_225535_a_((ServerWorld)world, world.field_73012_v, pos, state);
                WailmerPailItem.spawnBonemealParticles(world, pos, 15);
            } else {
                ChatHandler.sendChat((Entity)player, "pixelmon.blocks.bonemealwatered", new Object[0]);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void spawnBonemealParticles(World worldIn, BlockPos pos, int amount) {
        block5: {
            BlockState iblockstate;
            if (worldIn.field_72995_K) break block5;
            ServerWorld world = (ServerWorld)worldIn;
            if (amount == 0) {
                amount = 15;
            }
            if ((iblockstate = worldIn.func_180495_p(pos)).func_185904_a() != Material.field_151579_a) {
                for (int i = 0; i < amount; ++i) {
                    double d0 = field_77697_d.nextGaussian() * 0.02;
                    double d1 = field_77697_d.nextGaussian() * 0.02;
                    double d2 = field_77697_d.nextGaussian() * 0.02;
                    world.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * iblockstate.func_196954_c((IBlockReader)worldIn, pos).func_197758_c(Direction.Axis.Y), (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), 1, d0, d1, d2, 0.0);
                }
            } else {
                for (int i1 = 0; i1 < amount; ++i1) {
                    double d0 = field_77697_d.nextGaussian() * 0.02;
                    double d1 = field_77697_d.nextGaussian() * 0.02;
                    double d2 = field_77697_d.nextGaussian() * 0.02;
                    world.func_195598_a((IParticleData)ParticleTypes.field_197632_y, (double)((float)pos.func_177958_n() + field_77697_d.nextFloat()), (double)pos.func_177956_o() + (double)field_77697_d.nextFloat() * 1.0, (double)((float)pos.func_177952_p() + field_77697_d.nextFloat()), 1, d0, d1, d2, 0.0);
                }
            }
        }
    }
}

