/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TumblestoneItem
extends PixelmonItem {
    private Color color;
    private boolean raw;

    public TumblestoneItem(Color color, Item.Properties properties) {
        this(color, false, properties);
    }

    public TumblestoneItem(Color color, boolean raw, Item.Properties properties) {
        super(properties);
        this.color = color;
        this.raw = raw;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World worldIn = context.func_195991_k();
        PlayerEntity playerIn = context.func_195999_j();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        ItemStack stack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K || this.color == null) {
            return ActionResultType.SUCCESS;
        }
        if (!PixelmonConfigProxy.getGeneral().isAllowPlanting()) {
            return ActionResultType.FAIL;
        }
        if (!playerIn.func_184812_l_() || this.raw) {
            return ActionResultType.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos = pos.func_177984_a(), facing, stack)) {
            return ActionResultType.FAIL;
        }
        if (stack.func_190916_E() <= 0) {
            return ActionResultType.FAIL;
        }
        if (worldIn.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
            BlockState state = this.fromColour().func_176223_P();
            worldIn.func_180501_a(pos, state, 3);
            state = worldIn.func_180495_p(pos);
            state.func_177230_c().func_180633_a(worldIn, pos, state, (LivingEntity)playerIn, stack);
            if (!playerIn.func_184812_l_()) {
                if (stack.func_190916_E() <= 1) {
                    playerIn.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    stack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private Block fromColour() {
        if (this.color == Color.BLACK) {
            return PixelmonBlocks.black_tumblestone;
        }
        if (this.color == Color.RED) {
            return PixelmonBlocks.red_tumblestone;
        }
        return PixelmonBlocks.blue_tumblestone;
    }

    public boolean isRaw() {
        return this.raw;
    }
}

