/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.TMType;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TechnicalMoveItem
extends PixelmonItem {
    private final TMType prefix;

    public TechnicalMoveItem(TMType prefix) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_TM_TR));
        this.prefix = prefix;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!worldIn.field_72995_K) {
            if (TechnicalMoveItem.getMove(stack) == null) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74777_a("tm", (short)stack.func_77952_i());
                if (TechnicalMoveItem.getMove(stack) == null) {
                    stack.func_77978_p().func_74777_a("tm", (short)RandomHelper.getRandomElementFromArray(ITechnicalMove.getAllFor(this.prefix)).getId());
                }
            }
            if (stack.func_77952_i() != 0) {
                stack.func_196085_b(0);
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public String func_77667_c(ItemStack stack) {
        ITechnicalMove technicalMove = TechnicalMoveItem.getMove(stack);
        if (technicalMove == null || this.getRegistryName() == null) {
            return super.func_77667_c(stack);
        }
        return "item.pixelmon." + this.getRegistryName().func_110623_a() + "." + technicalMove.getId();
    }

    @Override
    public String getTooltipText(ItemStack stack) {
        String ret = "";
        ITechnicalMove technicalMove = TechnicalMoveItem.getMove(stack);
        if (technicalMove == null) {
            return ret;
        }
        ImmutableAttack ab = technicalMove.getAttack();
        if (ab == null || !ab.isAttack(technicalMove.getAttack())) {
            return ret;
        }
        String formattedData = I18n.func_135052_a((String)"tm.movedata.tooltip", (Object[])new Object[]{"&" + String.format("#%06X", 0xFFFFFF & ab.getAttackType().getColor()) + ab.getAttackType().getLocalizedName() + TextFormatting.GRAY, ab.getBasePower() != 0 ? Integer.valueOf(ab.getBasePower()) : "-", ab.getAccuracy() != -1 ? Integer.valueOf(ab.getAccuracy()) : "-", ab.getPPBase()});
        ret = ret + formattedData;
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".tooltip"))) {
            ret = ret + I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]);
        }
        return ret;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT compound = super.getShareTag(stack);
        if (compound != null && compound.func_74764_b("tm")) {
            compound.func_74768_a("tm", (int)compound.func_74765_d("tm"));
        }
        return compound;
    }

    public String type() {
        return this.prefix.name();
    }

    @Nullable
    public static ITechnicalMove getMove(ItemStack stack) {
        if (stack.func_77973_b() instanceof TechnicalMoveItem && stack.func_77942_o()) {
            short id = stack.func_77978_p().func_74765_d("tm");
            return ITechnicalMove.getMoveFor(((TechnicalMoveItem)stack.func_77973_b()).prefix, id);
        }
        return null;
    }

    @Nullable
    public static ITechnicalMove getInstanceOf(ItemStack stack) {
        if (stack.func_77973_b() instanceof TechnicalMoveItem) {
            return ITechnicalMove.getMoveFor(((TechnicalMoveItem)stack.func_77973_b()).prefix, 0);
        }
        return null;
    }

    public static ItemStack of(TMType type, ITechnicalMove move) {
        ItemStack stack = new ItemStack((IItemProvider)type.getItem());
        stack.func_77982_d(new CompoundNBT());
        stack.func_77978_p().func_74777_a("tm", (short)move.getId());
        return stack;
    }

    @Override
    public void func_150895_a(ItemGroup p_150895_1_, NonNullList<ItemStack> items) {
        if (this.func_194125_a(p_150895_1_)) {
            for (ITechnicalMove move : this.prefix.getMoves()) {
                items.add((Object)TechnicalMoveItem.of(this.prefix, move));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class TMPropertyGetter
    implements IItemPropertyGetter {
        public static final TMPropertyGetter INSTANCE = new TMPropertyGetter();

        public float call(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            ITechnicalMove move = TechnicalMoveItem.getMove(stack);
            if (move == null || move.getAttack() == null || move.getAttack().getAttackType() == null) {
                return 0.0f;
            }
            return move.getAttack().getAttackType().getIndex();
        }
    }
}

