/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.blocks.OrbBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.OrbTileEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumOrbShard;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ShardItem
extends PixelmonItem {
    public final EnumOrbShard shardType;
    public final Block block;

    public ShardItem(EnumOrbShard shardType) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_NATURAL));
        this.shardType = shardType;
        switch (shardType) {
            case RED: {
                this.block = PixelmonBlocks.red_orb;
                break;
            }
            case BLUE: {
                this.block = PixelmonBlocks.blue_orb;
                break;
            }
            default: {
                this.block = Blocks.field_150350_a;
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.field_72995_K || this.block == Blocks.field_150350_a) {
            return ActionResultType.SUCCESS;
        }
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        Hand hand = context.func_221531_n();
        Direction facing = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        Block groundBlock = world.func_180495_p(pos).func_177230_c();
        if (groundBlock == this.block) {
            try {
                OrbTileEntity tile = (OrbTileEntity)world.func_175625_s(pos);
                if (tile.getPieces() > 9 || !player.func_175151_a(pos, facing, stack)) {
                    return ActionResultType.FAIL;
                }
                tile.addPiece();
                world.func_184133_a(null, pos, SoundEvents.field_187567_bP, SoundCategory.BLOCKS, 1.0f, 10.0f);
                if (tile.getPieces() > 9) {
                    world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, 2.0f);
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
                world.func_217377_a(pos, false);
            }
        } else {
            if (facing != Direction.UP || !world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j() || !player.func_175151_a(pos.func_177984_a(), facing, stack)) {
                return ActionResultType.FAIL;
            }
            world.func_175656_a(pos.func_177984_a(), (BlockState)this.block.func_176223_P().func_206870_a((Property)OrbBlock.FACING, (Comparable)player.func_184172_bi()));
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

