/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.OpenBadgeCasePacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgeCase;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BadgeCaseItem
extends PixelmonItem
implements IEquippable {
    private final EnumBadgeCase color;

    public BadgeCaseItem(EnumBadgeCase color) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_BADGES).func_200917_a(1));
        this.color = color;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            BadgeCaseItem.openBadgeCase(stack, (ServerPlayerEntity)player);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    public String getTooltipText() {
        return I18n.func_135052_a((String)"item.pixelmon.badgecase.tooltip", (Object[])new Object[0]);
    }

    @Override
    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.CHEST;
    }

    @Override
    public String getEquippableModelKey() {
        return "badgecase";
    }

    @Override
    public ResourceLocation getEquippableTexture() {
        return null;
    }

    @Override
    public Item getEquippableItem() {
        return this;
    }

    public static void openBadgeCase(ItemStack stack, ServerPlayerEntity player) {
        if (stack.func_77973_b() instanceof BadgeCaseItem) {
            BadgeCase badgeCase = BadgeCase.readFromItemStack(stack);
            if (badgeCase == null) {
                NetworkHelper.sendPacket(new OpenBadgeCasePacket("", true, false, ((BadgeCaseItem)stack.func_77973_b()).color, Collections.emptyList(), Collections.emptyList()), player);
            } else {
                NetworkHelper.sendPacket(new OpenBadgeCasePacket(badgeCase.owner, badgeCase.isOwner((PlayerEntity)player), false, badgeCase.color, badgeCase.badges, Collections.emptyList()), player);
            }
        }
    }

    public static boolean registerBadgeCase(ItemStack stack, PlayerEntity player) {
        if (stack.func_77973_b() instanceof BadgeCaseItem) {
            BadgeCase badgeCase = BadgeCase.readFromItemStack(stack);
            if (badgeCase == null) {
                badgeCase = new BadgeCase(player.func_110124_au(), player.func_200200_C_().getString(), ((BadgeCaseItem)stack.func_77973_b()).color, Lists.newArrayList());
                badgeCase.writeToStack(stack);
                return true;
            }
            if (badgeCase.uuid == null) {
                badgeCase.uuid = player.func_110124_au();
                badgeCase.owner = player.func_200200_C_().getString();
                badgeCase.color = ((BadgeCaseItem)stack.func_77973_b()).color;
                badgeCase.writeToStack(stack);
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static ItemStack removeBadge(ItemStack stack, PlayerEntity player, int index) {
        BadgeCase badgeCase;
        if (stack.func_77973_b() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && index >= 0 && index < badgeCase.badges.size()) {
            ItemStack removed = badgeCase.badges.remove(index);
            badgeCase.writeToStack(stack);
            return removed != null ? removed : ItemStack.field_190927_a;
        }
        return ItemStack.field_190927_a;
    }

    public static void swampBadge(ItemStack stack, PlayerEntity player, int index1, int index2) {
        BadgeCase badgeCase;
        if (stack.func_77973_b() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && index1 >= 0 && index2 >= 0 && index1 < badgeCase.badges.size() && index2 < badgeCase.badges.size()) {
            ItemStack stack1 = badgeCase.badges.get(index1);
            ItemStack stack2 = badgeCase.badges.get(index2);
            badgeCase.badges.set(index1, stack2);
            badgeCase.badges.set(index2, stack1);
            badgeCase.writeToStack(stack);
        }
    }

    public static boolean addBadge(ItemStack stack, PlayerEntity player, ItemStack badge) {
        BadgeCase badgeCase;
        if (stack.func_77973_b() instanceof BadgeCaseItem && (badgeCase = BadgeCase.readFromItemStack(stack)) != null && badgeCase.isOwner(player) && badgeCase.badges.size() < 64) {
            badgeCase.badges.add(badge);
            badgeCase.writeToStack(stack);
            return true;
        }
        return false;
    }

    @Nullable
    public static ItemStack findFirstRegisteredBadgeCase(PlayerEntity player) {
        BadgeCase badgeCase;
        for (ItemStack stack : player.func_184214_aD()) {
            if (!(stack.func_77973_b() instanceof BadgeCaseItem) || (badgeCase = BadgeCase.readFromItemStack(stack)) == null || !badgeCase.isOwner(player)) continue;
            return stack;
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!(stack.func_77973_b() instanceof BadgeCaseItem) || (badgeCase = BadgeCase.readFromItemStack(stack)) == null || !badgeCase.isOwner(player)) continue;
            return stack;
        }
        return null;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return (!stack.func_77942_o() || !stack.func_77978_p().func_74767_n("Unequippable")) && this.getEquipmentSlot(stack) == armorType;
    }

    public static class BadgeCase {
        private UUID uuid;
        private String owner;
        private EnumBadgeCase color;
        public List<ItemStack> badges;

        public BadgeCase(UUID uuid, String owner, EnumBadgeCase color, List<ItemStack> badges) {
            this.uuid = uuid;
            this.owner = owner;
            this.color = color;
            this.badges = badges;
        }

        public boolean isOwner(PlayerEntity player) {
            return player.func_110124_au().equals(this.uuid);
        }

        public void writeToStack(ItemStack stack) {
            CompoundNBT compound = stack.func_196082_o();
            if (this.uuid != null) {
                compound.func_186854_a("OwnerUUID", this.uuid);
                compound.func_74778_a("OwnerName", this.owner);
            } else {
                compound.func_82580_o("OwnerUUID");
                compound.func_82580_o("OwnerName");
            }
            if (!this.badges.isEmpty()) {
                ListNBT list = new ListNBT();
                for (ItemStack badge : this.badges) {
                    list.add((Object)badge.func_77955_b(new CompoundNBT()));
                }
                compound.func_218657_a("Badges", (INBT)list);
            } else {
                compound.func_82580_o("Badges");
            }
        }

        public static BadgeCase readFromItemStack(ItemStack stack) {
            if (!(stack.func_77973_b() instanceof BadgeCaseItem)) {
                return null;
            }
            CompoundNBT compound = stack.func_77978_p();
            if (compound == null) {
                return null;
            }
            UUID uuid = null;
            String owner = "";
            EnumBadgeCase color = ((BadgeCaseItem)stack.func_77973_b()).color;
            ArrayList badges = Lists.newArrayList();
            if (compound.func_74764_b("OwnerUUID")) {
                uuid = compound.func_186857_a("OwnerUUID");
                owner = compound.func_74779_i("OwnerName");
            }
            if (compound.func_74764_b("Badges")) {
                ListNBT list = compound.func_150295_c("Badges", 10);
                for (INBT tag : list) {
                    badges.add(ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)tag)));
                }
            }
            return new BadgeCase(uuid, owner, color, badges);
        }
    }
}

