/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.projectiles;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.events.FishingEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.items.SpawnActionItem;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.conditions.TriggerLocation;
import com.pixelmonmod.pixelmon.api.spawning.util.SpatialData;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.DropItemHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.items.EnumRodType;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.items.FishingRodItem;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class HookEntity
extends FishingBobberEntity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> DATA_HOOK_STATE = EntityDataManager.func_187226_a(HookEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private EnumRodType rodType;
    private SpawnAction<? extends Entity> caught = null;
    private int ticksTillCatch = 0;
    private int ticksTillEscape = 0;
    private float chanceOfNothing = 0.0f;
    private HookState state = HookState.FLYING;
    private int dotsShowing = 0;
    private int momentsShowingDots = 0;
    private int rodQuality = 0;

    @OnlyIn(value=Dist.CLIENT)
    public HookEntity(World world, PlayerEntity player, double x, double y, double z) {
        super(world, player, x, y, z);
        this.init(player);
    }

    public HookEntity(World world, PlayerEntity player, EnumRodType rodType, int rodQuality) {
        super(player, world, rodType.rarityThreshold, rodQuality);
        this.rodType = rodType;
        this.rodQuality = rodQuality;
        this.init(player);
    }

    public EntityType<?> func_200600_R() {
        return (EntityType)EntityRegistration.HOOK.get();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_HOOK_STATE, (Object)-1);
    }

    public void init(PlayerEntity player) {
        this.field_70158_ak = true;
        if (player != null) {
            this.setAngler((Entity)player);
            player.field_71104_cf = this;
        }
    }

    public void func_70186_c(double p_70186_1_, double p_70186_3_, double p_70186_5_, float p_70186_7_, float p_70186_8_) {
        if (this.func_234616_v_() != null) {
            super.func_70186_c(p_70186_1_, p_70186_3_, p_70186_5_, p_70186_7_, p_70186_8_);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        UUID uuid = this.func_234616_v_() != null ? this.func_234616_v_().func_110124_au() : new UUID(0L, 0L);
        buffer.func_179252_a(uuid);
    }

    public void readSpawnData(PacketBuffer additionalData) {
    }

    public void setAngler(Entity entity) {
        if (entity instanceof PlayerEntity) {
            this.func_212361_a(entity);
            ((PlayerEntity)entity).field_71104_cf = this;
        }
    }

    public void func_70071_h_() {
        Entity shooter = this.func_234616_v_();
        if (!(shooter instanceof PlayerEntity) || ((PlayerEntity)shooter).field_71104_cf != this) {
            this.func_241204_bJ_();
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            ++this.momentsShowingDots;
            if (this.momentsShowingDots > 40) {
                this.momentsShowingDots = 0;
                this.dotsShowing = (this.dotsShowing + 1) % 3;
            }
        }
        --this.ticksTillCatch;
        --this.ticksTillEscape;
        if (this.ticksTillEscape == 0 && this.caught != null) {
            this.caught = null;
            if (shooter != null) {
                ChatHandler.sendFormattedChat((ICommandSource)shooter, TextFormatting.GRAY, "pixelmon.projectiles.gotaway", new Object[0]);
                if (!this.field_70170_p.field_72995_K) {
                    this.func_241204_bJ_();
                }
            }
        }
        this.func_70030_z();
        if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.field_70122_E) {
                ++this.field_146049_av;
                if (this.field_146049_av >= 1200) {
                    this.func_241204_bJ_();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Vector3i)this.func_233580_cy_());
            BlockState blockState = this.field_70170_p.func_180495_p(blockpos);
            if (BetterSpawnerConfig.getWaterBlocks().contains(blockState.func_177230_c()) || BetterSpawnerConfig.getLavaBlocks().contains(blockState.func_177230_c())) {
                FluidState fluidState = this.field_70170_p.func_204610_c(blockpos);
                f = fluidState.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (this.state == HookState.FLYING) {
                if (this.field_146043_c != null) {
                    this.func_213317_d(Vector3d.field_186680_a);
                    this.state = HookState.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.state = HookState.BOBBING;
                    if (!this.field_70170_p.field_72995_K) {
                        this.setNewTimeToCatch();
                    }
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!this.field_70122_E && !this.field_70123_F) {
                    ++this.field_146045_ax;
                } else {
                    this.field_146045_ax = 0;
                    this.func_213317_d(Vector3d.field_186680_a);
                }
            } else {
                if (this.state == HookState.HOOKED_IN_ENTITY) {
                    if (this.field_146043_c != null) {
                        if (!this.field_146043_c.func_70089_S()) {
                            this.field_146043_c = null;
                            this.state = HookState.FLYING;
                        } else {
                            this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_174813_aQ().field_72338_b + (double)this.field_146043_c.func_213302_cg() * 0.8, this.field_146043_c.func_226281_cx_());
                        }
                    }
                    return;
                }
                if (this.state == HookState.BOBBING) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.9, 1.0, 0.9));
                    double d0 = this.func_226278_cu_() + this.func_213322_ci().field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    if (!this.field_70170_p.field_72995_K && this.ticksTillCatch == 0 && this.func_234616_v_() != null && this.func_234616_v_().func_184102_h() != null) {
                        if (f > 0.0f && this.field_146043_c == null) {
                            this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - (double)Math.abs(this.field_70146_Z.nextFloat()) * 0.2, this.func_213322_ci().field_72449_c);
                            if (PixelmonSpawning.fishingSpawner == null) {
                                return;
                            }
                            SpawnLocation spawnLocation = this.createSpawnLocation();
                            SpawnAction<? extends Entity> caught = PixelmonSpawning.fishingSpawner.getAction(spawnLocation, 1.0f - this.chanceOfNothing);
                            if (spawnLocation.diameter == 0) {
                                caught = null;
                            }
                            int displayedMarks = 1;
                            if (caught != null) {
                                this.caught = caught;
                                int ticksTillEscape = 30;
                                float nominalRarity = caught.spawnInfo.calculateNominalRarity();
                                displayedMarks = nominalRarity < 5.0f ? 3 : (nominalRarity < 50.0f ? 2 : 1);
                                FishingEvent.Catch catchEvent = new FishingEvent.Catch((ServerPlayerEntity)shooter, this, caught, ticksTillEscape, displayedMarks);
                                if (Pixelmon.EVENT_BUS.post((Event)catchEvent)) {
                                    caught = null;
                                } else {
                                    this.func_184212_Q().func_187227_b(DATA_HOOK_STATE, (Object)catchEvent.getDisplayedMarks());
                                    this.ticksTillEscape = catchEvent.getTicksTillEscape();
                                }
                            }
                            if (caught == null) {
                                ChatHandler.sendFormattedChat((ICommandSource)shooter, TextFormatting.GRAY, "pixelmon.projectiles.nibble", new Object[0]);
                                this.func_241204_bJ_();
                            }
                        }
                    } else {
                        this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, this.func_213322_ci().func_82616_c());
                    }
                }
            }
            if (blockState.func_185904_a() != Material.field_151586_h && blockState.func_185904_a() != Material.field_151587_i) {
                this.func_213293_j(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b() - 0.03, this.func_213322_ci().func_82616_c());
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_234617_x_();
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.92, 0.92, 0.92));
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
    }

    public SpawnLocation createSpawnLocation() {
        BlockPos pos = new BlockPos((Vector3i)this.func_233580_cy_());
        BlockState state = this.field_70170_p.func_180495_p(pos);
        TriggerLocation loc = BetterSpawnerConfig.getWaterBlocks().contains(state.func_177230_c()) ? this.rodType.locationInWater : (BetterSpawnerConfig.getLavaBlocks().contains(state.func_177230_c()) ? this.rodType.locationInLava : null);
        TriggerLocation qualityLoc = null;
        switch (this.rodQuality) {
            case 0: {
                qualityLoc = LocationType.OK_ROD_QUALITY;
                break;
            }
            case 1: {
                qualityLoc = LocationType.SO_SO_ROD_QUALITY;
                break;
            }
            case 2: {
                qualityLoc = LocationType.GOOD_ROD_QUALITY;
                break;
            }
            case 3: {
                qualityLoc = LocationType.GREAT_ROD_QUALITY;
                break;
            }
            case 4: {
                qualityLoc = LocationType.RARE_ROD_QUALITY;
                break;
            }
            case 5: {
                qualityLoc = LocationType.PRO_ROD_QUALITY;
                break;
            }
            case 6: {
                qualityLoc = LocationType.SUPREME_ROD_QUALITY;
            }
        }
        if (this.rodType == EnumRodType.OasRod) {
            qualityLoc = LocationType.SUPREME_ROD_QUALITY;
        }
        SpatialData data = PixelmonSpawning.fishingSpawner.calculateSpatialData(this.field_70170_p, this.func_233580_cy_(), 10, true, block -> {
            if (BetterSpawnerConfig.getWaterBlocks().contains(block)) {
                return true;
            }
            if (BetterSpawnerConfig.getLavaBlocks().contains(block)) {
                return true;
            }
            return BetterSpawnerConfig.getAirBlocks().contains(block);
        });
        HashSet sets = Sets.newHashSet((Object[])new LocationType[]{loc});
        if (qualityLoc != null) {
            sets.add(qualityLoc);
        }
        return new SpawnLocation(this.func_234616_v_(), new MutableLocation(this.field_70170_p, pos), sets, data.baseBlock, data.uniqueSurroundingBlocks, this.field_70170_p.func_226691_t_(pos), SpawningHeightmap.canSeeSky(pos, this.field_70170_p), data.radius, this.field_70170_p.func_201696_r(pos.func_177984_a()));
    }

    public void setNewTimeToCatch() {
        this.caught = null;
        this.ticksTillCatch = 20 * RandomHelper.getRandomNumberBetween(5, 15);
        FishingEvent.Cast castEvent = new FishingEvent.Cast((ServerPlayerEntity)this.func_234616_v_(), this, this.ticksTillCatch, this.chanceOfNothing);
        Pixelmon.EVENT_BUS.post((Event)castEvent);
        this.ticksTillCatch = castEvent.getTicksUntilCatch();
        this.chanceOfNothing = castEvent.getChanceOfNothing();
        this.func_184212_Q().func_187227_b(DATA_HOOK_STATE, (Object)0);
    }

    public boolean shouldStopFishing() {
        boolean flag1;
        ItemStack itemstack = ((PlayerEntity)this.func_234616_v_()).func_184614_ca();
        ItemStack itemstack1 = ((PlayerEntity)this.func_234616_v_()).func_184592_cb();
        boolean flag = itemstack.func_77973_b() instanceof FishingRodItem && ((FishingRodItem)itemstack.func_77973_b()).getRodType() == this.rodType;
        boolean bl = flag1 = itemstack1.func_77973_b() instanceof FishingRodItem && ((FishingRodItem)itemstack1.func_77973_b()).getRodType() == this.rodType;
        if (this.func_234616_v_().func_70089_S() && this.func_234616_v_().func_70089_S() && (flag || flag1) && this.func_70068_e(this.func_234616_v_()) <= 1024.0) {
            return false;
        }
        this.func_241204_bJ_();
        return true;
    }

    public void func_234617_x_() {
        float f = MathHelper.func_76133_a((double)(this.func_213322_ci().func_82615_a() * this.func_213322_ci().func_82617_b() + this.func_213322_ci().func_82616_c() * this.func_213322_ci().func_82616_c()));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82615_a(), (double)this.func_213322_ci().func_82616_c()) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().func_82617_b(), (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
    }

    private void checkCollision() {
        Vector3d vec3d = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        Vector3d vec3d1 = new Vector3d(this.func_226277_ct_() + this.func_213322_ci().func_82615_a(), this.func_226278_cu_() + this.func_213322_ci().func_82617_b(), this.func_226281_cx_() + this.func_213322_ci().func_82616_c());
        BlockRayTraceResult raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this));
        vec3d = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        vec3d1 = new Vector3d(this.func_226277_ct_() + this.func_213322_ci().func_82615_a(), this.func_226278_cu_() + this.func_213322_ci().func_82617_b(), this.func_226281_cx_() + this.func_213322_ci().func_82616_c());
        if (raytraceresult != null) {
            vec3d1 = new Vector3d(raytraceresult.func_216347_e().field_72450_a, raytraceresult.func_216347_e().field_72448_b, raytraceresult.func_216347_e().field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c()).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            Vector3d raytraceresult1;
            if (!this.func_230298_a_(entity1) || entity1 == this.func_234616_v_() && this.field_70173_aa < 5 || (raytraceresult1 = (Vector3d)(axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_216365_b(vec3d, vec3d1).orElse(null)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new EntityRayTraceResult(entity);
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                this.func_184212_Q().func_187227_b(field_184528_c, (Object)(this.field_146043_c.func_145782_y() + 1));
            } else {
                this.field_70122_E = true;
                this.field_146045_ax = 0;
                this.ticksTillEscape = 0;
                this.caught = null;
                this.state = HookState.FLYING;
                this.func_184212_Q().func_187227_b(DATA_HOOK_STATE, (Object)-1);
            }
        }
    }

    public int func_146034_e(ItemStack p_146034_1_) {
        if (this.field_70170_p.field_72995_K) {
            return 0;
        }
        int b0 = 0;
        if (this.field_146043_c != null) {
            this.func_184527_k();
            this.field_70170_p.func_72960_a((Entity)this, (byte)31);
            b0 = 3;
            this.func_241204_bJ_();
            return b0;
        }
        Entity entity = this.caught == null ? null : this.caught.doSpawn(PixelmonSpawning.fishingSpawner);
        FishingEvent.Reel reelEvent = new FishingEvent.Reel((ServerPlayerEntity)this.func_234616_v_(), this, entity);
        Pixelmon.EVENT_BUS.post((Event)reelEvent);
        if (this.caught != null) {
            if (entity == null) {
                return b0;
            }
            if (this.caught instanceof SpawnActionPokemon) {
                PixelmonEntity pokemon = (PixelmonEntity)((SpawnActionPokemon)this.caught).getOrCreateEntity();
                pokemon.setSpawnLocation(SpawnLocationType.WATER);
                pokemon.resetAI();
                PlayerPartyStorage storage = StorageProxy.getParty((ServerPlayerEntity)this.func_234616_v_());
                if (storage.countAblePokemon() > 0) {
                    WildPixelmonParticipant wpp = new WildPixelmonParticipant(pokemon);
                    PlayerParticipant pp = new PlayerParticipant((ServerPlayerEntity)this.func_234616_v_(), storage.getAndSendOutFirstAblePokemon(this.func_234616_v_()));
                    BattleRegistry.startBattle(pp, wpp);
                }
            } else if (this.caught instanceof SpawnActionItem) {
                ItemEntity caughtItem = (ItemEntity)entity;
                ItemStack stack = caughtItem.func_92059_d();
                caughtItem.func_70106_y();
                ChatHandler.sendFormattedChat((ICommandSource)this.func_234616_v_(), TextFormatting.GREEN, "pixelmon.projectiles.fisheditem", stack.func_190916_E(), new TranslationTextComponent(stack.func_77973_b().func_77667_c(stack) + ""));
                DropItemHelper.giveItemStack((ServerPlayerEntity)this.func_234616_v_(), stack, false);
            }
        }
        if (this.field_70122_E) {
            b0 = 2;
        }
        this.func_241204_bJ_();
        this.field_146043_c = null;
        return b0;
    }

    public EnumRodType getRodType() {
        return this.rodType;
    }

    public int getDotsShowing() {
        return this.dotsShowing;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum HookState {
        BOBBING,
        FLYING,
        HOOKED_IN_ENTITY;

    }
}

