/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.DiglettParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.FlameParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.GastlyParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.KoffingParticles;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.WeezingParticles;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class ParticleEffects {
    static Map<Species, ParticleEffects> map = Maps.newHashMap();
    Random rand = RandomHelper.rand;

    static void init() {
        PixelmonSpecies.WEEZING.ifInitialized(species -> map.put((Species)species, new WeezingParticles()));
        PixelmonSpecies.KOFFING.ifInitialized(species -> map.put((Species)species, new KoffingParticles()));
        PixelmonSpecies.DIGLETT.ifInitialized(species -> map.put((Species)species, new DiglettParticles()));
        PixelmonSpecies.DUGTRIO.ifInitialized(species -> map.put((Species)species, new DiglettParticles()));
        PixelmonSpecies.GASTLY.ifInitialized(species -> map.put((Species)species, new GastlyParticles()));
        PixelmonSpecies.CHARMANDER.ifInitialized(species -> map.put((Species)species, new FlameParticles(0.7f, 0.45f, 3)));
        PixelmonSpecies.CHARMELEON.ifInitialized(species -> map.put((Species)species, new FlameParticles(1.2f, 0.7f, 5)));
        PixelmonSpecies.CHIMCHAR.ifInitialized(species -> map.put((Species)species, new FlameParticles(0.3f, 0.38f, 3)));
        PixelmonSpecies.MONFERNO.ifInitialized(species -> map.put((Species)species, new FlameParticles(0.84f, 0.81f, 5)));
    }

    public static Set<ParticleEffects> getParticleEffects(AbstractClientEntity pixelmon) {
        if (map.isEmpty()) {
            ParticleEffects.init();
        }
        HashSet effects = Sets.newHashSet();
        if (map.containsKey(pixelmon.getSpecies())) {
            effects.add(map.get(pixelmon.getSpecies()));
        }
        if (pixelmon.transformed != null) {
            if (pixelmon.transformedParticles != null) {
                effects.add(pixelmon.transformedParticles);
            }
        } else if (pixelmon.getPalette().getParticle() != null) {
            effects.add(pixelmon.getPalette().getParticle());
        }
        return effects;
    }

    public abstract void onUpdate(AbstractClientEntity var1);
}

