/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public class Lightning {
    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("lightning_bolt").setName("pixelmon.moveskill.lightning_bolt").describe("pixelmon.moveskill.lightning_bolt.description").setDefaultCooldownTicks(500).setRange(7).setUsePP(true).setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/lightning.png")).setAnyMoves("Thunderbolt", "Bolt Strike", "Thunder", "Spark", "Discharge", "Fusion Bolt", "Thunder Shock");
        return moveSkill.setBehaviourMultiTarget((pixelmon, data) -> {
            ServerPlayerEntity player = (ServerPlayerEntity)pixelmon.getOwner();
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            ServerWorld world = (ServerWorld)pixelmon.field_70170_p;
            BlockPos pos = data instanceof LivingEntity ? ((LivingEntity)data).func_233580_cy_() : (BlockPos)((Tuple)data).func_76341_a();
            if (Lightning.canLightningStrike((World)world, pos) && !world.func_73046_m().func_175579_a(world, pos, (PlayerEntity)player)) {
                LightningBoltEntity entity = new LightningBoltEntity(EntityType.field_200728_aG, (World)world);
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                world.func_217376_c((Entity)entity);
                return moveSkill.cooldownTicks - pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            }
            return -1;
        }, MoveSkill.EnumTargetType.BLOCK, MoveSkill.EnumTargetType.MISC_ENTITY);
    }

    private static boolean canLightningStrike(World world, BlockPos strikePosition) {
        Biome Biome2 = world.func_226691_t_(strikePosition);
        return Biome2.func_201851_b() == Biome.RainType.RAIN;
    }
}

