/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.util.Scheduling;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.tools.LineCalc;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Cut {
    public static int maximumLogs = 100;
    public static int ticksBetweenChops = 2;
    public static ArrayList<Direction[]> checkDirections = Lists.newArrayList((Object[])new Direction[][]{{Direction.NORTH}, {Direction.SOUTH}, {Direction.EAST}, {Direction.WEST}, {Direction.UP}, {Direction.UP, Direction.NORTH}, {Direction.UP, Direction.SOUTH}, {Direction.UP, Direction.EAST}, {Direction.UP, Direction.WEST}});

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("cut").setName("pixelmon.moveskill.cut").describe("pixelmon.moveskill.cut.description1", "pixelmon.moveskill.cut.description2").setIcon(ResourceLocationHelper.of("pixelmon", "textures/gui/overlay/externalmoves/cut.png")).setAnyMoves("Cut").setUsePP(true).setRange(8);
        moveSkill.setBehaviourBlockTarget((pixelmon, tup) -> {
            if (!PixelmonConfigProxy.getExternalMoves().isAllowDestructiveExternalMoves()) {
                return -1;
            }
            World world = pixelmon.field_70170_p;
            BlockPos pos = (BlockPos)tup.func_76341_a();
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151575_d) {
                return -1;
            }
            ArrayList<BlockPos> logs = Cut.findTreeLogs(world, pos);
            int logCount = logs.size();
            if (logs.size() > maximumLogs) {
                ChatHandler.sendChat((Entity)pixelmon.getOwner(), "pixelmon.moveskill.cut.toomany", new Object[0]);
                return -1;
            }
            float maxLogs = LineCalc.lerp(pixelmon.getPokemon().getStat(BattleStatsType.ATTACK), 1.0f, 300.0f, 1.0f, maximumLogs);
            if (maxLogs <= (float)logs.size()) {
                ChatHandler.sendChat((Entity)pixelmon.getOwner(), "pixelmon.moveskill.cut.fail", pixelmon.getPokemon().getDisplayName());
                return -1;
            }
            Scheduling.schedule(ticksBetweenChops, task -> {
                if (!logs.isEmpty()) {
                    ServerPlayerEntity player = (ServerPlayerEntity)pixelmon.getOwner();
                    if (player == null) {
                        return;
                    }
                    BlockPos log = (BlockPos)logs.remove(0);
                    BlockState state = world.func_180495_p(log);
                    ItemStack hand = player.func_184582_a(EquipmentSlotType.MAINHAND);
                    try {
                        player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                        ((ServerPlayerEntity)pixelmon.getOwner()).field_71134_c.func_180237_b(log);
                    }
                    finally {
                        player.func_184201_a(EquipmentSlotType.MAINHAND, hand);
                    }
                }
                if (logs.isEmpty()) {
                    task.repeats = false;
                }
            }, true);
            float speed = pixelmon.getPokemon().getStat(BattleStatsType.SPEED);
            return (int)(200.0f + (float)(logCount * 20) * (1.5f - LineCalc.ratio(speed, 1.0f, 200.0f)));
        });
        return moveSkill;
    }

    private static ArrayList<BlockPos> findTreeLogs(World world, BlockPos pos) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> newLogs = new ArrayList<BlockPos>();
        newLogs.add(pos);
        while (!newLogs.isEmpty()) {
            Cut.addAdjacentLogs(world, (BlockPos)newLogs.get(0), newLogs, logs);
            logs.add(newLogs.get(0));
            newLogs.remove(0);
        }
        return logs;
    }

    private static void addAdjacentLogs(World world, BlockPos pos, ArrayList<BlockPos> newLogs, ArrayList<BlockPos> logs) {
        for (Direction[] facings : checkDirections) {
            BlockPos loc = pos;
            for (Direction f : facings) {
                loc = loc.func_177972_a(f);
            }
            if (world.func_180495_p(loc).func_185904_a() != Material.field_151575_d || Cut.hasLog(logs, loc) || Cut.hasLog(newLogs, loc)) continue;
            newLogs.add(loc);
        }
    }

    private static boolean hasLog(ArrayList<BlockPos> logs, BlockPos loc) {
        for (BlockPos log : logs) {
            if (!log.equals((Object)loc)) continue;
            return true;
        }
        return false;
    }
}

