/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemonPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class EvolutionQueryList {
    public static final List<EvolutionQuery> queryList = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void declineQuery(ServerPlayerEntity player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.decline();
                    queryList.remove(i);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acceptQuery(ServerPlayerEntity player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                if (query.player == player) {
                    query.accept();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EvolutionQuery get(PlayerEntity player) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                if (q.player != player) continue;
                return q;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(World world) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery q = queryList.get(i);
                q.tick(world);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spawnPokemon(ServerPlayerEntity player, UUID pokemonUUID) {
        List<EvolutionQuery> list = queryList;
        synchronized (list) {
            for (int i = 0; i < queryList.size(); ++i) {
                EvolutionQuery query = queryList.get(i);
                if (!query.pokemonUUID.equals(pokemonUUID)) continue;
                PlayerPartyStorage party = StorageProxy.getParty(player);
                PixelmonEntity pixelmon = party.find(pokemonUUID).getOrSpawnPixelmon((Entity)player);
                if (pixelmon == null || party.find(pokemonUUID).getPixelmonEntity() == null) {
                    return;
                }
                NetworkHelper.sendNearbyPacket(new EvolvePokemonPacket(pokemonUUID, EvolutionStage.Choice), new PacketDistributor.TargetPoint(pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), 60.0, pixelmon.field_70170_p.func_234923_W_()));
                return;
            }
        }
    }
}

