/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon;

import com.google.common.collect.Lists;
import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.PokerusStrain;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTierRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.aggression.Aggression;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Pokerus;
import com.pixelmonmod.pixelmon.api.registries.PixelmonEggGroups;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;

public abstract class AbstractBaseEntity
extends AbstractHorseEntity {
    private static final List<Vector3i> SURROUNDING_POSITIONS = Lists.newArrayList((Object[])new Vector3i[]{new Vector3i(1, 0, 0), new Vector3i(-1, 0, 0), new Vector3i(0, 1, 0), new Vector3i(0, -1, 0), new Vector3i(0, 0, 1), new Vector3i(0, 0, -1)});
    public static final DataSync<? extends AbstractBaseEntity, BossTier> SYNC_BOSS_MODE = new DataSync<AbstractBaseEntity, BossTier>(AbstractBaseEntity.class, PixelmonDataSerializers.BOSS_MODE, (abstractBaseEntity, boss) -> {
        abstractBaseEntity.bossTier = boss;
    });
    public static final DataSync<? extends AbstractBaseEntity, Integer> SYNC_MAX_HP = new DataSync<AbstractBaseEntity, Integer>(AbstractBaseEntity.class, DataSerializers.field_187192_b, (abstractBaseEntity, maxHp) -> {});
    public static final DataSync<? extends AbstractBaseEntity, SpawnLocationType> SYNC_SPAWN_LOCATION = new DataSync<AbstractBaseEntity, SpawnLocationType>(AbstractBaseEntity.class, PixelmonDataSerializers.SPAWN_LOCATION_TYPE, (abstractBaseEntity, spawnLocation) -> {
        abstractBaseEntity.spawnLocation = spawnLocation;
    });
    public static final DataSync<? extends AbstractBaseEntity, Float> SYNC_SCALE = new DataSync<AbstractBaseEntity, Float>(AbstractBaseEntity.class, DataSerializers.field_187193_c, (abstractBaseEntity, scale) -> {
        abstractBaseEntity.scale = scale.floatValue();
    });
    public static final DataSync<? extends AbstractBaseEntity, Optional<UUID>> SYNC_OWNER_UUID = new DataSync<AbstractBaseEntity, Optional>(AbstractBaseEntity.class, DataSerializers.field_187203_m, (abstractBaseEntity, uuid) -> {
        abstractBaseEntity.ownerUUID = uuid.orElse(null);
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_NAMETAG_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, DataSerializers.field_187198_h, (abstractBaseEntity, disableNametag) -> {
        abstractBaseEntity.disableNametag = disableNametag;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_SHADOW_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, DataSerializers.field_187198_h, (abstractBaseEntity, disableShadow) -> {
        abstractBaseEntity.disableShadow = disableShadow;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_OVERLAY = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, DataSerializers.field_187198_h, (abstractBaseEntity, overlay) -> {
        abstractBaseEntity.overlay = overlay;
    });
    public static final DataSync<? extends AbstractBaseEntity, Optional<Color>> SYNC_COLOR = new DataSync<AbstractBaseEntity, Optional>(AbstractBaseEntity.class, PixelmonDataSerializers.OPTIONAL_COLOR, (abstractBaseEntity, color) -> {
        abstractBaseEntity.color = color.orElse(null);
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_TEXTURE_DISABLE = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, DataSerializers.field_187198_h, (abstractBaseEntity, disableTexture) -> {
        abstractBaseEntity.disableTexture = disableTexture;
    });
    public static final DataSync<? extends AbstractBaseEntity, Boolean> SYNC_FULLBRIGHT = new DataSync<AbstractBaseEntity, Boolean>(AbstractBaseEntity.class, DataSerializers.field_187198_h, (abstractBaseEntity, fullbright) -> {
        abstractBaseEntity.fullbright = fullbright;
    });
    protected Pokemon pokemon;
    public PokeBallEntity hitByPokeball = null;
    public boolean canDespawn = true;
    private boolean isImmuneToFire = false;
    private UUID ownerUUID;
    private boolean disableNametag;
    private boolean disableShadow;
    private boolean overlay;
    private Color color;
    private boolean disableTexture;
    private boolean fullbright;
    public Aggression aggression;
    protected SpawnLocationType spawnLocation = SpawnLocationType.LAND;
    protected BossTier bossTier = BossTierRegistry.NOT_BOSS;
    private EntitySize dimensions;
    private List<DataParameter<?>> delay = Lists.newArrayList();
    protected float scale = 1.0f;
    protected EntityDataSyncManager dataSyncManager;

    public AbstractBaseEntity(EntityType<? extends AbstractBaseEntity> type, World par1World) {
        super(type, par1World);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.define(PokemonBase.SYNC_POKEMON_BASE, new PokemonBase(PixelmonSpecies.BULBASAUR.getValueUnsafe()));
        this.define(Pokemon.SYNC_GROWTH, null);
        this.define(SYNC_BOSS_MODE, BossTierRegistry.NOT_BOSS);
        this.define(Pokemon.SYNC_LEVEL, -1);
        this.define(SYNC_MAX_HP, 10);
        this.define(Pokemon.SYNC_EXP, 0);
        this.define(Pokemon.SYNC_NICK_NAME, StringTextComponent.field_240750_d_);
        this.define(SYNC_SPAWN_LOCATION, SpawnLocationType.LAND);
        this.define(Pokemon.SYNC_ENTITY_UUID, Optional.of(this.func_110124_au()));
        this.define(Pokemon.SYNC_RIBBON, null);
        this.define(Pokemon.SYNC_FLAGS, new String[0]);
        this.define(SYNC_SCALE, Float.valueOf(1.0f));
        this.define(SYNC_OWNER_UUID, Optional.empty());
        this.define(SYNC_NAMETAG_DISABLE, false);
        this.define(SYNC_SHADOW_DISABLE, false);
        this.define(SYNC_OVERLAY, false);
        this.define(SYNC_COLOR, Optional.empty());
        this.define(SYNC_TEXTURE_DISABLE, false);
        this.define(SYNC_FULLBRIGHT, false);
        this.dataSyncManager.addRegisteredSync(Pokemon.SYNC_HEALTH);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public boolean func_110248_bS() {
        return this.func_184780_dh() != null && this.getForm().getMovement().isRideable();
    }

    public boolean func_110167_bD() {
        return this.func_110248_bS();
    }

    protected boolean func_184228_n(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return this.isOwnedBy((LivingEntity)entity);
    }

    public boolean func_230264_L__() {
        return false;
    }

    public boolean func_110257_ck() {
        return this.func_110248_bS();
    }

    public void func_110199_f(PlayerEntity p_110199_1_) {
    }

    @Nullable
    protected SoundEvent func_230274_fe_() {
        return this.func_184639_G();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.func_184639_G();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.func_184639_G();
    }

    protected void func_205715_ee() {
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        return this.func_184639_G();
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
    }

    protected void func_190680_a(SoundType p_190680_1_) {
    }

    public void resetDataWatchers() {
        SYNC_OWNER_UUID.set((Entity)this, Optional.ofNullable(this.pokemon.getOwnerPlayerUUID()));
        PokemonBase.SYNC_POKEMON_BASE.set((Entity)this, (Object)this.pokemon);
        Pokemon.SYNC_GROWTH.set((Entity)this, (Object)this.pokemon.getGrowth());
        SYNC_BOSS_MODE.set((Entity)this, (Object)(this.bossTier == null ? BossTierRegistry.NOT_BOSS : this.bossTier));
        Pokemon.SYNC_LEVEL.set((Entity)this, (Object)this.pokemon.getPokemonLevel());
        SYNC_MAX_HP.set((Entity)this, (Object)this.pokemon.getMaxHealth());
        Pokemon.SYNC_EXP.set((Entity)this, (Object)this.pokemon.getExperience());
        SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(1.0f));
        Pokemon.SYNC_NICK_NAME.set((Entity)this, (Object)(this.pokemon.getFormattedNickname() == null ? StringTextComponent.field_240750_d_ : this.pokemon.getFormattedNickname()));
        SYNC_SPAWN_LOCATION.set((Entity)this, (Object)this.spawnLocation);
        Pokemon.SYNC_ENTITY_UUID.set((Entity)this, Optional.of(this.pokemon.getUUID()));
        Pokemon.SYNC_RIBBON.set((Entity)this, (Object)this.pokemon.getDisplayedRibbon());
        Pokemon.SYNC_FLAGS.set((Entity)this, (Object)this.pokemon.getFlags().toArray(new String[0]));
    }

    public void setPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        this.func_184221_a(this.pokemon.getUUID());
        this.resetDataWatchers();
        this.initBaseEntity();
        this.func_70606_j(pokemon.getHealth());
        if (RandomHelper.getRandomChance(this.getForm().getAggression().getPassive())) {
            this.setAggression(Aggression.PASSIVE);
        } else if (RandomHelper.getRandomChance(this.getForm().getAggression().getTimid())) {
            this.setAggression(Aggression.TIMID);
        } else if (RandomHelper.getRandomChance(this.getForm().getAggression().getAggressive())) {
            this.setAggression(Aggression.AGGRESSIVE);
        }
        if (!this.field_70170_p.field_72995_K && pokemon.getPokerus() == null && PixelmonConfigProxy.getGeneral().getPokerus().isEnabled() && PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate() > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfigProxy.getGeneral().getPokerus().getSpawnRate())) {
            pokemon.setPokerus(new Pokerus(PokerusStrain.getRandomType()));
        }
    }

    public void func_184221_a(UUID uuid) {
        super.func_184221_a(uuid);
        if (this.getPokemon() == null) {
            return;
        }
        Pokemon.SYNC_ENTITY_UUID.set((Entity)this, Optional.of(uuid));
    }

    public void initBaseEntity() {
        List<Element> types = this.getForm().getTypes();
        if (this.getForm().getMovement().getSwimmingParameters() != null) {
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a((double)this.getForm().getMovement().getSwimmingParameters().getSwimSpeed());
        } else {
            this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111128_a(5.0);
        }
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.5 - 0.5 / (double)Math.max(1, this.pokemon.getStats().getSpeed()));
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.pokemon.getMaxHealth());
        this.func_110148_a(Attributes.field_233830_m_).func_111128_a(this.func_110245_cM());
        this.setDimensions(new EntitySize((float)this.getForm().getDimensions().getWidth(), (float)this.getForm().getDimensions().getHeight() + this.getForm().getHoverHeight(), false));
        this.isImmuneToFire = types.contains(Element.FIRE) || types.contains(Element.WATER) || this.getForm().getEggGroups().contains(PixelmonEggGroups.MINERAL);
    }

    public boolean func_230279_az_() {
        return this.isImmuneToFire;
    }

    public void setDimensions(EntitySize dimensions) {
        this.dimensions = dimensions;
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return this.dimensions;
    }

    public boolean hasPalette() {
        return !this.getPokemon().getPalette().getName().equalsIgnoreCase("none");
    }

    public PaletteProperties getPalette() {
        return this.pokemon.getPalette();
    }

    public GenderProperties getGenderProperties() {
        return this.pokemon.getGenderProperties();
    }

    public boolean isPalette(String paletteName) {
        if (this.getPokemon() == null || this.getPalette() == null) {
            return false;
        }
        return this.getPalette().getName().equalsIgnoreCase(paletteName);
    }

    public Pokemon getPokemon() {
        return this.pokemon;
    }

    public Stats getForm() {
        if (this.getPokemon() == null) {
            return this.getSpecies().getDefaultForm();
        }
        return this.getPokemon().getForm();
    }

    public Species getSpecies() {
        if (this.pokemon == null || this.pokemon.getSpecies() == null) {
            this.func_241204_bJ_();
            return PixelmonSpecies.BULBASAUR.getValueUnsafe();
        }
        return this.pokemon.getSpecies();
    }

    public boolean isPokemon(Species ... species) {
        return this.pokemon.isPokemon(species);
    }

    @SafeVarargs
    public final boolean isPokemon(Optional<Species> ... species) {
        return this.pokemon.isPokemonOptional(species);
    }

    @SafeVarargs
    public final boolean isPokemon(RegistryValue<Species> ... species) {
        return this.pokemon.isPokemonOptional(species);
    }

    public BossTier getBossTier() {
        if (this.bossTier == null) {
            this.setBossTier(BossTierRegistry.NOT_BOSS);
        }
        return this.bossTier;
    }

    public void setBossTier(BossTier tier) {
        if (tier == null) {
            tier = BossTierRegistry.NOT_BOSS;
        }
        SYNC_BOSS_MODE.set((Entity)this, (Object)tier);
    }

    public boolean isBossPokemon() {
        return this.getBossTier().isBoss();
    }

    public boolean isLegendary() {
        return this.getPokemon() != null && this.getPokemon().isLegendary();
    }

    public Aggression getAggression() {
        if (this.aggression == null) {
            return Aggression.PASSIVE;
        }
        return this.aggression;
    }

    public void setAggression(Aggression aggression) {
        if (aggression == null) {
            aggression = Aggression.PASSIVE;
        }
        this.aggression = aggression;
    }

    public SpawnLocationType getSpawnLocation() {
        return this.spawnLocation;
    }

    public void setSpawnLocation(SpawnLocationType spawnLocation) {
        if (spawnLocation == null) {
            spawnLocation = SpawnLocationType.LAND;
        }
        SYNC_SPAWN_LOCATION.set((Entity)this, (Object)spawnLocation);
    }

    public boolean hasOwner() {
        return this.func_184780_dh() != null;
    }

    @Nullable
    public UUID func_184780_dh() {
        if (this.field_70170_p.field_72995_K) {
            return this.ownerUUID;
        }
        return this.pokemon == null ? null : this.pokemon.getOwnerPlayerUUID();
    }

    public void func_184779_b(@Nullable UUID uuid) {
        SYNC_OWNER_UUID.set((Entity)this, Optional.ofNullable(uuid));
    }

    @Nullable
    public LivingEntity getOwner() {
        UUID uuid = this.func_184780_dh();
        return uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
    }

    public boolean isOwnedBy(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public boolean belongsTo(PlayerEntity player) {
        return Objects.equals(player.func_110124_au(), this.pokemon.getOwnerPlayerUUID());
    }

    public void update(EnumUpdateType ... types) {
        this.pokemon.markDirty(types);
    }

    @Nullable
    public PokemonStorage getStorage() {
        return (PokemonStorage)this.pokemon.getStorageAndPosition().func_76341_a();
    }

    @Nullable
    public PlayerPartyStorage getPlayerParty() {
        PokemonStorage storage = this.getStorage();
        if (storage != null && storage instanceof PlayerPartyStorage) {
            return (PlayerPartyStorage)storage;
        }
        return null;
    }

    public Optional<PlayerPartyStorage> getPlayerStorage() {
        if (this.pokemon.getStorageAndPosition() != null && this.pokemon.getStorageAndPosition().func_76341_a() instanceof PlayerPartyStorage) {
            return Optional.of((PlayerPartyStorage)this.pokemon.getStorageAndPosition().func_76341_a());
        }
        return Optional.empty();
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent(this.getPokemonName());
    }

    public boolean func_145818_k_() {
        return false;
    }

    public String getPokemonName() {
        return this.getSpecies().getName();
    }

    public String getLocalizedName() {
        return this.pokemon.getLocalizedName();
    }

    public String getNickname() {
        return this.pokemon.getDisplayName();
    }

    public float getPixelmonScale() {
        if (this.field_70180_af == null) {
            return 1.0f;
        }
        return this.scale;
    }

    public void setPixelmonScale(float scale) {
        SYNC_SCALE.set((Entity)this, (Object)Float.valueOf(scale));
    }

    public void resetAlterations(float scale) {
        this.setPixelmonScale(scale);
        this.setOverlay(false);
        this.setColor(null);
        this.setDisableTexture(false);
        this.setDisableNametag(false);
        this.setDisableShadow(false);
        this.setFullbright(false);
    }

    public String getEscapedNickname() {
        return Matcher.quoteReplacement(this.getNickname());
    }

    public boolean func_70094_T() {
        if (super.func_70094_T()) {
            for (Vector3i position : SURROUNDING_POSITIONS) {
                BlockHelper.getPropertyValue(this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177971_a(position)), BlockStateProperties.field_208189_p).ifPresent(t -> this.func_70107_b(this.func_226277_ct_() + (double)position.func_177958_n(), this.func_226278_cu_() + (double)position.func_177956_o(), this.func_226281_cx_() + (double)position.func_177952_p()));
            }
            return super.func_70094_T();
        }
        return false;
    }

    public ItemStack func_184614_ca() {
        return this.pokemon.getHeldItem();
    }

    public boolean func_70104_M() {
        return true;
    }

    public int func_70874_b() {
        return 0;
    }

    public boolean func_213397_c(double p_213397_1_) {
        return true;
    }

    @Nullable
    public Entity func_241206_a_(ServerWorld p_241206_1_) {
        return null;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return null;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return this.getOwner() == player;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76364_f() == this.getOwner()) {
            this.pokemon.decreaseFriendship(20);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity bolt) {
        if (PixelmonSpecies.MAGIKARP.isInitialized() && Objects.equals(this.getSpecies(), PixelmonSpecies.MAGIKARP.getValueUnsafe())) {
            this.getPokemon().setPalette("roasted");
        } else {
            super.func_241841_a(world, bolt);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.getSpawnLocation() == SpawnLocationType.WATER) {
            return false;
        }
        return super.func_225503_b_(distance, damageMultiplier);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        this.pokemon.writeToNBT(nbt);
        if (this.func_184780_dh() != null) {
            nbt.func_186854_a("Owner", this.func_184780_dh());
        } else {
            nbt.func_82580_o("Owner");
        }
        if (this.aggression != null && this.aggression != Aggression.PASSIVE) {
            nbt.func_74774_a("Aggression", (byte)this.aggression.ordinal());
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_186855_b("Owner")) {
            this.func_184779_b(nbt.func_186857_a("Owner"));
        }
        if (this.pokemon == null) {
            this.pokemon = PokemonFactory.create(UUID.randomUUID());
            this.func_184221_a(this.pokemon.getUUID());
        }
        this.pokemon.readFromNBT(nbt);
        this.resetDataWatchers();
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.pokemon.getMaxHealth());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(0.55);
        this.aggression = nbt.func_74764_b("Aggression") ? Aggression.getAggression(nbt.func_74771_c("Aggression")) : Aggression.PASSIVE;
    }

    public void func_184206_a(DataParameter<?> key) {
        DataSync<?, ?> dataSync;
        if (this.getPokemon() == null && this.dataSyncManager.isRegistered(key)) {
            if (key.func_187155_a() == PokemonBase.SYNC_POKEMON_BASE.getParameterId()) {
                PokemonBase base = (PokemonBase)this.field_70180_af.func_187225_a(PokemonBase.SYNC_POKEMON_BASE.getDataParameter());
                this.pokemon = base.toPokemon();
                for (DataParameter<?> dataParameter : this.delay) {
                    this.dataSyncManager.getSync(dataParameter).onSyncedDataUpdated(dataParameter, (Entity)this);
                }
            } else {
                if (this.delay == null) {
                    this.delay = Lists.newArrayList();
                }
                this.delay.add(key);
                return;
            }
        }
        if ((dataSync = this.dataSyncManager.getSync(key)) != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }

    public boolean isDisableNametag() {
        return this.disableNametag;
    }

    public void setDisableNametag(boolean disableNametag) {
        SYNC_NAMETAG_DISABLE.set((Entity)this, (Object)disableNametag);
    }

    public boolean isDisableShadow() {
        return this.disableShadow;
    }

    public void setDisableShadow(boolean disableShadow) {
        SYNC_SHADOW_DISABLE.set((Entity)this, (Object)disableShadow);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public void setOverlay(boolean overlay) {
        SYNC_OVERLAY.set((Entity)this, (Object)overlay);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        SYNC_COLOR.set((Entity)this, Optional.ofNullable(color));
    }

    public boolean isDisableTexture() {
        return this.disableTexture;
    }

    public void setDisableTexture(boolean disableTexture) {
        SYNC_TEXTURE_DISABLE.set((Entity)this, (Object)disableTexture);
    }

    public boolean isFullbright() {
        return this.fullbright;
    }

    public void setFullbright(boolean fullbright) {
        SYNC_FULLBRIGHT.set((Entity)this, (Object)fullbright);
    }
}

