/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;

public abstract class IndexedNPCEntity
extends NPCEntity {
    protected int nameIndex;
    protected int chatIndex;
    protected String npcIndex = "NPC";

    public IndexedNPCEntity(EntityType<? extends IndexedNPCEntity> type, World world) {
        super(type, world);
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("TrainerIndex", this.npcIndex);
        nbt.func_74768_a("ChatIndex", this.chatIndex);
        nbt.func_74768_a("NameIndex", this.nameIndex);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.npcIndex = nbt.func_74779_i("TrainerIndex");
        this.chatIndex = nbt.func_74762_e("ChatIndex");
        this.nameIndex = nbt.func_74762_e("NameIndex");
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/" + this.getCustomSteveTexture();
    }

    @Override
    public String getDisplayText() {
        return "";
    }

    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public boolean interactWithNPC(PlayerEntity player, Hand hand) {
        return false;
    }

    public ArrayList<String> getChat(String langCode) {
        int index = this.chatIndex;
        return new ArrayList<String>(Arrays.asList(ServerNPCRegistry.villagers.getTranslatedChat(langCode, this.npcIndex, index)));
    }

    public String getName(String langCode) {
        int index = this.nameIndex;
        return ServerNPCRegistry.villagers.getTranslatedName(langCode, this.npcIndex, index);
    }

    public Entity getEntity() {
        return super.getEntity();
    }

    public boolean shouldRiderSit() {
        return super.shouldRiderSit();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return super.getPickedResult(target);
    }

    public boolean canRiderInteract() {
        return super.canRiderInteract();
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return super.canBeRiddenInWater(rider);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        return super.getClassification(forSpawnCount);
    }

    public boolean isMultipartEntity() {
        return super.isMultipartEntity();
    }

    @Nullable
    public PartEntity<?>[] getParts() {
        return super.getParts();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }
}

