/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.custom;

import com.pixelmonmod.pixelmon.api.data.DataSync;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityDataSyncManager;
import com.pixelmonmod.pixelmon.init.registry.EntityRegistration;
import com.pixelmonmod.pixelmon.init.registry.PixelmonWoodType;
import java.util.stream.Collectors;
import net.minecraft.block.WoodType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class PixelmonBoatEntity
extends BoatEntity {
    public static final DataSync<PixelmonBoatEntity, WoodType> WOOD_TYPE_DATA_SYNC = new DataSync<PixelmonBoatEntity, WoodType>(PixelmonBoatEntity.class, PixelmonDataSerializers.WOOD_TYPE, (pixelmonBoatEntity, woodType1) -> {
        pixelmonBoatEntity.woodType = woodType1;
    });
    protected WoodType woodType;
    protected EntityDataSyncManager dataSyncManager;

    public PixelmonBoatEntity(EntityType<? extends BoatEntity> p_i50129_1_, World p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.field_70156_m = true;
    }

    public PixelmonBoatEntity(World level, double x, double y, double z) {
        super((EntityType)EntityRegistration.BOAT.get(), level);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70142_S = x;
        this.field_70137_T = y;
        this.field_70136_U = z;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.define(WOOD_TYPE_DATA_SYNC, PixelmonWoodType.BLUE_BERRY_WOOD);
    }

    protected <A> void define(DataSync<?, A> sync, A value) {
        if (this.dataSyncManager == null) {
            this.dataSyncManager = new EntityDataSyncManager();
        }
        this.dataSyncManager.define((Entity)this, sync, value);
    }

    public Item func_184455_j() {
        if (this.getWoodType() == PixelmonWoodType.BLUE_BERRY_WOOD) {
            return PixelmonItems.blue_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.GREEN_BERRY_WOOD) {
            return PixelmonItems.green_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.PINK_BERRY_WOOD) {
            return PixelmonItems.pink_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.PURPLE_BERRY_WOOD) {
            return PixelmonItems.purple_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.RED_BERRY_WOOD) {
            return PixelmonItems.red_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.YELLOW_BERRY_WOOD) {
            return PixelmonItems.yellow_berry_wood_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_ELM_WOOD) {
            return PixelmonItems.ultra_elm_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_GINGKO_WOOD) {
            return PixelmonItems.ultra_gingko_boat;
        }
        if (this.getWoodType() == PixelmonWoodType.ULTRA_JUNGLE_WOOD) {
            return PixelmonItems.ultra_jungle_boat;
        }
        return null;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public void setWoodType(WoodType woodType) {
        WOOD_TYPE_DATA_SYNC.set((Entity)this, (Object)woodType);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return super.getPickedResult(target);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("BoatType", this.woodType.func_227048_b_());
    }

    protected void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        String type = nbt.func_74779_i("BoatType");
        this.setWoodType((WoodType)RandomHelper.getRandomElementFromCollection(WoodType.func_227046_a_().filter(woodType1 -> woodType1.func_227048_b_().equalsIgnoreCase(type)).collect(Collectors.toList())));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        DataSync<?, ?> dataSync = this.dataSyncManager.getSync(key);
        if (dataSync != null) {
            dataSync.onSyncedDataUpdated(key, (Entity)this);
        }
    }
}

