/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.GenderProperties;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DevSpriteCheckCommand
extends PixelCommand {
    public DevSpriteCheckCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "devspritecheck", "/devsc", 4);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        for (Species species : PixelmonSpecies.getAll()) {
            for (Stats form : species.getForms()) {
                for (Gender possibleGender : form.getPossibleGenders()) {
                    GenderProperties genderProperties = form.getGenderProperties(possibleGender);
                    for (PaletteProperties palette : genderProperties.getPalettes()) {
                        if (!CommonProxy.resourceLocationExists(palette.getTexture())) {
                            Pixelmon.LOGGER.warn(species.getName() + " " + form.getName() + " " + possibleGender.getTranslationKey() + " missing texture " + palette.getTexture().toString());
                        }
                        if (CommonProxy.resourceLocationExists(palette.getSprite())) continue;
                        Pixelmon.LOGGER.warn(species.getName() + " " + form.getName() + " " + possibleGender.getTranslationKey() + " missing sprite " + palette.getSprite().toString());
                    }
                }
            }
        }
        sender.func_197030_a((ITextComponent)new StringTextComponent("Logged all missing textures, sprites and PQCs"), true);
    }
}

