/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class SpecTestCommand
extends PixelCommand {
    public SpecTestCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "spectest", "/spectest", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            sender.func_197021_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.failure.not_player"));
            return;
        }
        if (args.length == 0) {
            sender.func_197021_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.failure.no_spec"));
            return;
        }
        PokemonSpecification spec = PokemonSpecificationProxy.create(args);
        ServerPlayerEntity player = (ServerPlayerEntity)sender.func_197022_f();
        ArrowEntity arrow = new ArrowEntity((World)sender.func_197023_e(), (LivingEntity)player);
        arrow.func_213317_d(player.func_70040_Z().func_186678_a(10.0));
        arrow.func_174826_a(player.func_174813_aQ().func_186662_g(1.0));
        RayTraceResult hitResult = SpecTestCommand.getHitResult((Entity)arrow, entity -> !Objects.equals(player, entity));
        if (hitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            sender.func_197021_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.failure.miss"));
            return;
        }
        EntityRayTraceResult result = (EntityRayTraceResult)hitResult;
        if (result.func_216346_c() != RayTraceResult.Type.ENTITY || !(result.func_216348_a() instanceof PixelmonEntity)) {
            sender.func_197021_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.failure.not_pokemon"));
            return;
        }
        boolean matches = spec.matches(result.func_216348_a());
        if (matches) {
            sender.func_197030_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.success"), false);
            return;
        }
        sender.func_197021_a((ITextComponent)TextHelper.translate("pixelmon.command.spectest.failure"));
    }

    public static RayTraceResult getHitResult(Entity entity, Predicate<Entity> test) {
        EntityRayTraceResult raytraceresult1;
        Vector3d vector3d2;
        Vector3d vector3d = entity.func_213322_ci();
        World world = entity.field_70170_p;
        Vector3d vector3d1 = entity.func_213303_ch();
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(vector3d1, vector3d2 = vector3d1.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d2 = raytraceresult.func_216347_e();
        }
        if ((raytraceresult1 = ProjectileHelper.func_221269_a((World)world, (Entity)entity, (Vector3d)vector3d1, (Vector3d)vector3d2, (AxisAlignedBB)entity.func_174813_aQ().func_216361_a(entity.func_213322_ci()).func_186662_g(1.0), test)) != null) {
            raytraceresult = raytraceresult1;
        }
        return raytraceresult;
    }

    @Nullable
    public static EntityRayTraceResult getEntityHitResult(World level, Entity origin, Vector3d position, Vector3d p_221269_3_, AxisAlignedBB p_221269_4_, Predicate<Entity> p_221269_5_) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : level.func_175674_a(origin, p_221269_4_, p_221269_5_)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ();
            Optional optional = axisalignedbb.func_216365_b(position, p_221269_3_);
            if (!optional.isPresent() || !((d1 = position.func_72436_e((Vector3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        return PixelmonCommandUtils.tabCompleteUsernames();
    }
}

