/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PokeSpawnCommand
extends PixelCommand {
    public PokeSpawnCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokespawn", "/pokespawn <pokemon> [<x> <y> <z>]", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            BlockPos pos;
            ServerWorld world = sender.func_197023_e();
            PixelmonEntity pokemon = PixelmonCommandUtils.require(PokemonSpecificationProxy.create(args).create((World)world), "pixelmon.command.general.notingame", args[0]);
            boolean specContainsMissingNo = false;
            for (String arg : args) {
                if (!arg.toLowerCase(Locale.ROOT).contains("missingno")) continue;
                specContainsMissingNo = true;
            }
            if (pokemon.isPokemon(PixelmonSpecies.MISSINGNO) && !specContainsMissingNo) {
                sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
                PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
                return;
            }
            if (args.length >= 4) {
                try {
                    pos = new BlockPos(Integer.parseInt(args[1]), Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                }
                catch (NumberFormatException e) {
                    pos = new BlockPos(sender.func_197036_d());
                }
            } else {
                pos = new BlockPos(sender.func_197036_d());
            }
            pokemon.func_70107_b(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            pokemon.canDespawn = false;
            pokemon.setSpawnLocation(pokemon.getDefaultSpawnLocation());
            world.func_217376_c((Entity)pokemon);
            pokemon.resetAI();
            PixelmonCommandUtils.sendMessage(sender, "pixelmon.command.spawn.spawned", pokemon.getSpecies().getTranslatedName());
            PixelmonCommandUtils.notifyCommandListener(sender, this, 0, "pixelmon.command.spawn.spawnednotify", sender.func_197037_c(), pokemon.getSpecies().getTranslatedName());
        } else {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) {
        ArrayList all = Lists.newArrayList();
        all.addAll(PixelmonCommandUtils.SPEC_REQUIREMENTS);
        all.addAll(PixelmonSpecies.getFormattedEnglishNameSet());
        return all;
    }
}

