/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.server.ServerWorld;

public class PokeKillCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pkill"});

    public PokeKillCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokekill", "/pokekill <specs...>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        ServerWorld world = PixelmonCommandUtils.getWorld(args, sender);
        PokemonSpecification spec = PokemonSpecificationProxy.create(args);
        int count = 0;
        for (Entity entity : world.getEntities().collect(Collectors.toList())) {
            PixelmonEntity pixelmon;
            if (!(entity instanceof PixelmonEntity) || (pixelmon = (PixelmonEntity)entity).hasOwner() || pixelmon.battleController != null || spec != null && !spec.matches(pixelmon)) continue;
            pixelmon.func_174812_G();
            ++count;
        }
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.pokekill.success", count), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length <= 1) {
            return PixelmonCommandUtils.SPEC_REQUIREMENTS;
        }
        return Collections.emptyList();
    }
}

