/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.events.PokegiftEvent;
import com.pixelmonmod.pixelmon.api.events.PokemonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class GiftCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"psell", "pokegift", "pgift", "gift"});

    public GiftCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "pokesell", "/pokesell <player> <slot>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        if (args.length < 2) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.playercommand", new Object[0]));
            return;
        }
        ServerPlayerEntity self = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPartyStorage selfStorage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(self), "pixelmon.command.general.invalidplayer", new Object[0]);
        if (self.func_200200_C_().getString().equals(args[0])) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.gift.toself", new Object[0]));
            return;
        }
        ServerPlayerEntity target = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PlayerPartyStorage targetStorage = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage(target), "pixelmon.command.general.invalidplayer", new Object[0]);
        int slot = PixelmonCommandUtils.requireInt(args[1], 1, 6, "pixelmon.command.invalidslot", args[1]);
        Pokemon pokemon = PixelmonCommandUtils.require(selfStorage.get(slot - 1), "pixelmon.command.partyslot.nothing", self.func_200200_C_().getString());
        if (pokemon.hasFlag("untradeable")) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.gift.untradeable", new Object[0]));
            return;
        }
        if (selfStorage.getTeam().size() == 1 && !pokemon.isEgg()) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.gift.partyspace", new Object[0]));
            return;
        }
        if (selfStorage.inTemporaryMode()) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.gift.selftemporarymode", new Object[0]));
            return;
        }
        if (targetStorage.inTemporaryMode()) {
            sender.func_197021_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.gift.targettemporarymode", new Object[0]));
            return;
        }
        selfStorage.retrieveAll("Command");
        if (Pixelmon.EVENT_BUS.post((Event)new PokemonReceivedEvent(target, pokemon, "GiftCommand"))) {
            return;
        }
        if (Pixelmon.EVENT_BUS.post((Event)new PokegiftEvent(self, target, pokemon))) {
            return;
        }
        selfStorage.set(slot - 1, null);
        targetStorage.add(pokemon);
        target.func_145747_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.gift.received", self.func_200200_C_().getString(), pokemon.getTranslatedName().getString()), Util.field_240973_b_);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.gift.gifted", target.func_200200_C_().getString(), pokemon.getTranslatedName().getString()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompleteUsernames();
        }
        if (args.length == 2) {
            return PixelmonCommandUtils.PARTY_SLOTS;
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

