/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokemon.species.Pokedex;
import com.pixelmonmod.pixelmon.api.util.helpers.NumberHelper;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class DexCheckCommand
extends PixelCommand {
    public DexCheckCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "dexcheck", "/dexcheck", 0);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException {
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(sender);
        PlayerPokedex dex = PixelmonCommandUtils.require(PixelmonCommandUtils.getPlayerStorage((ServerPlayerEntity)player), (String)"pixelmon.command.general.invalidplayer", (Object[])new Object[0]).playerPokedex;
        int caught = dex.countCaught();
        BigDecimal percent = BigDecimal.valueOf(caught).divide(BigDecimal.valueOf(Pokedex.pokedexSize), new MathContext(5, RoundingMode.HALF_EVEN)).multiply(BigDecimal.valueOf(100L));
        String percentString = NumberHelper.formatPercentage(percent.doubleValue());
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.dexcheck", "" + TextFormatting.DARK_AQUA + caught + TextFormatting.GOLD, "" + TextFormatting.DARK_AQUA + Pokedex.pokedexSize + TextFormatting.GOLD, "" + TextFormatting.DARK_AQUA + percentString + TextFormatting.GOLD), false);
    }
}

