/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde;

import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.ZygardeCubeItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ZygardeCubePacket
extends AbstractPixelmonPacket {
    private boolean learnMove = false;
    private int move;
    private int cubeSlot;
    private StoragePosition position;

    public ZygardeCubePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ZygardeCubePacket(StoragePosition position, int cubeSlot, int move) {
        super(PacketDirection.PLAY_SERVER, true);
        this.learnMove = true;
        this.move = move;
        this.cubeSlot = cubeSlot;
        this.position = position;
    }

    public ZygardeCubePacket(StoragePosition position, int cubeSlot) {
        super(PacketDirection.PLAY_SERVER, true);
        this.learnMove = false;
        this.cubeSlot = cubeSlot;
        this.position = position;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.learnMove = buf.readBoolean();
        if (this.learnMove) {
            this.move = buf.readInt();
        }
        this.cubeSlot = buf.readInt();
        this.position = StoragePosition.decode((ByteBuf)buf);
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.learnMove);
        if (this.learnMove) {
            buf.writeInt(this.move);
        }
        buf.writeInt(this.cubeSlot);
        this.position.encode((ByteBuf)buf);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        Pokemon pokemon = storage.get(this.position);
        ItemStack cube = player.field_71071_by.func_70301_a(this.cubeSlot);
        if (cube.func_77973_b() instanceof ZygardeCubeItem && pokemon != null && pokemon.getSpecies().is(PixelmonSpecies.ZYGARDE)) {
            if (this.learnMove) {
                ImmutableAttack attack;
                ZygardeCubeItem.CoreType core = ZygardeCubeItem.CoreType.fromIndex(this.move);
                if (ZygardeCubeItem.hasCore(cube, core) && (attack = core.getMove()) != null) {
                    if (!pokemon.getMoveset().hasAttack(core.getMove())) {
                        if (pokemon.getMoveset().size() >= 4) {
                            LearnMoveController.sendLearnMove(player, pokemon.getUUID(), attack);
                        } else {
                            pokemon.getMoveset().add(new Attack(attack));
                            ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.GREEN, "pixelmon.stats.learnedmove", pokemon.getDisplayName(), attack.getTranslatedName());
                        }
                    } else {
                        ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.interaction.tmknown", pokemon.getDisplayName(), attack.getTranslatedName());
                    }
                }
            } else if (pokemon.getAbility() instanceof PowerConstruct) {
                Stats form = pokemon.getForm();
                pokemon.setForm(form.isForm("ten_percent") ? "fifty_percent" : "ten_percent");
            }
        }
    }
}

