/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.vendingMachine;

import com.pixelmonmod.pixelmon.api.economy.BankAccount;
import com.pixelmonmod.pixelmon.api.economy.BankAccountProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.machines.VendingMachineBlock;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItemWithVariation;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class VendingMachinePacket
extends AbstractPixelmonPacket {
    private String itemID;
    private BlockPos pos;

    public VendingMachinePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public VendingMachinePacket(BlockPos pos, String itemName) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pos = pos;
        this.itemID = itemName;
    }

    @Override
    public void decode(PacketBuffer buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.itemID = buf.func_218666_n();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.func_180714_a(this.itemID);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!BlockHelper.validateReach(player, this.pos)) {
            return;
        }
        BlockState state = player.field_70170_p.func_180495_p(this.pos);
        BankAccount account = BankAccountProxy.getBankAccount(player).orElse(null);
        if (!(state.func_177230_c() instanceof VendingMachineBlock) || account == null) {
            return;
        }
        ArrayList<ShopItemWithVariation> itemList = ((VendingMachineBlock)state.func_177230_c()).getShop().getItems();
        for (ShopItemWithVariation s : itemList) {
            if (!s.getBaseShopItem().id.equals(this.itemID) || !account.hasBalance(s.getBuyCost())) continue;
            ItemStack item = s.getItemStack();
            ItemStack buyStack = item.func_77946_l();
            buyStack.func_190920_e(1);
            if (!player.func_191521_c(buyStack)) continue;
            account.take(s.getBuyCost());
            player.field_71069_bz.func_75142_b();
            player.func_71053_j();
        }
    }
}

