/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.trading;

import com.pixelmonmod.pixelmon.blocks.tileentity.TradeMachineTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.EnumServerTradesMode;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ServerTradesPacket
extends AbstractPixelmonPacket {
    private EnumServerTradesMode mode;
    private int pos = 0;
    private boolean ready = false;
    private BlockPos tradeMachine;

    public ServerTradesPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public ServerTradesPacket(EnumServerTradesMode mode, BlockPos tradeMachine) {
        super(PacketDirection.PLAY_SERVER);
        this.mode = mode;
        this.tradeMachine = tradeMachine;
    }

    public static ServerTradesPacket getTradePacket(BlockPos tradeMachine) {
        return new ServerTradesPacket(EnumServerTradesMode.Trade, tradeMachine);
    }

    public static ServerTradesPacket getDeRegisterPacket(BlockPos tradeMachine) {
        return new ServerTradesPacket(EnumServerTradesMode.DeRegisterTrader, tradeMachine);
    }

    public ServerTradesPacket(int pos, BlockPos tradeMachine) {
        this(EnumServerTradesMode.SelectPokemon, tradeMachine);
        this.pos = pos;
    }

    public ServerTradesPacket(boolean ready, BlockPos tradeMachine) {
        this(EnumServerTradesMode.Ready, tradeMachine);
        this.ready = ready;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.mode.ordinal());
        buffer.writeInt(this.pos);
        buffer.writeBoolean(this.ready);
        buffer.writeLong(this.tradeMachine.func_218275_a());
    }

    @Override
    public void decode(PacketBuffer buffer) {
        short ind = buffer.readShort();
        for (EnumServerTradesMode m : EnumServerTradesMode.values()) {
            if (m.ordinal() != ind) continue;
            this.mode = m;
        }
        this.pos = buffer.readInt();
        this.ready = buffer.readBoolean();
        this.tradeMachine = BlockPos.func_218283_e((long)buffer.readLong());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        BlockPos p;
        ServerPlayerEntity player = context.getSender();
        if (player.func_70092_e((double)(p = this.tradeMachine).func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5) <= 64.0) {
            context.enqueueWork(() -> {
                TileEntity te = player.func_71121_q().func_175625_s(p);
                if (te instanceof TradeMachineTileEntity) {
                    TradeMachineTileEntity tradeMachine = (TradeMachineTileEntity)te;
                    if (this.mode == EnumServerTradesMode.SelectPokemon) {
                        if (tradeMachine.player1 == player) {
                            tradeMachine.setPos1(this.pos);
                        } else if (tradeMachine.player2 == player) {
                            tradeMachine.setPos2(this.pos);
                        }
                    } else if (this.mode == EnumServerTradesMode.DeRegisterTrader) {
                        tradeMachine.removePlayer((PlayerEntity)player);
                    } else if (this.mode == EnumServerTradesMode.Ready) {
                        tradeMachine.ready((PlayerEntity)player, this.ready);
                    } else if (this.mode == EnumServerTradesMode.Trade) {
                        tradeMachine.trade();
                    }
                }
            });
        }
    }
}

