/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PokeDisplaySwapPacket
extends AbstractPixelmonPacket {
    private BlockPos pos;
    private int newSlot;

    public PokeDisplaySwapPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public PokeDisplaySwapPacket(BlockPos pos, int newSlot) {
        this();
        this.pos = pos;
        this.newSlot = newSlot;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.newSlot);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.newSlot = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        PokeDisplayTileEntity tileEntity = (PokeDisplayTileEntity)sender.field_70170_p.func_175625_s(this.pos);
        PlayerPartyStorage party = StorageProxy.getParty(sender);
        if (!tileEntity.isLockedBy((PlayerEntity)sender)) {
            return;
        }
        if (this.newSlot != -1) {
            tileEntity.getStoredPoke().ifPresent(party::add);
            tileEntity.setStoredPoke(party.get(this.newSlot));
            party.set(this.newSlot, null);
        }
        tileEntity.setLocked(null);
    }
}

