/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PartyEditorBaseScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetImportPokemonIDPacket
extends AbstractPixelmonPacket {
    int partySlot;
    UUID pokemonUUID;

    public SetImportPokemonIDPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public SetImportPokemonIDPacket(int partySlot, UUID pokemonUUID) {
        super(PacketDirection.PLAY_CLIENT);
        this.partySlot = partySlot;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.partySlot);
        buf.func_179252_a(this.pokemonUUID);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.partySlot = buf.readInt();
        this.pokemonUUID = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        Pokemon pokemon = null;
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        List<Pokemon> pokemonList = null;
        if (currentScreen instanceof PartyEditorBaseScreen) {
            PartyEditorBaseScreen partyEditor = (PartyEditorBaseScreen)currentScreen;
            pokemonList = partyEditor.pokemonList;
        } else {
            pokemonList = ServerStorageDisplay.editedPokemon;
        }
        if (pokemonList != null && pokemonList.size() > this.partySlot) {
            pokemon = pokemonList.get(this.partySlot);
        }
        if (pokemon != null) {
            pokemon.setUUID(this.pokemonUUID);
        }
    }
}

