/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DeletePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private UUID pokemonUUID;

    public DeletePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public DeletePokemonPacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = PokemonEditorPartyScreen.editedPlayerUUID;
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.playerID);
        buf.func_179252_a(this.pokemonUUID);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerID = buf.func_179253_g();
        this.pokemonUUID = buf.func_179253_g();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party;
        int slot;
        if (PokemonEditorItem.checkPermission(context.getSender()) && (slot = (party = StorageProxy.getParty(this.playerID)).getSlot(this.pokemonUUID)) != -1) {
            DeletePokemonPacket.deletePokemon(this.playerID, slot, context);
        }
    }

    public static void deletePokemon(UUID playerID, int slot, NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage party = StorageProxy.getParty(playerID);
        party.set(slot, null);
        PokemonEditorItem.updateSinglePokemon(player, playerID, slot);
    }
}

