/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor;

import com.pixelmonmod.pixelmon.api.pokemon.InitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.PokemonEditorPartyScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.PokemonEditorItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ChangePokemonPacket
extends AbstractPixelmonPacket {
    private UUID playerID;
    private UUID pokemonUUID;
    private Species newPokemon;

    public ChangePokemonPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ChangePokemonPacket(UUID pokemonUUID, Species newPokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.playerID = PokemonEditorPartyScreen.editedPlayerUUID;
        this.pokemonUUID = pokemonUUID;
        this.newPokemon = newPokemon;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.playerID);
        buf.func_179252_a(this.pokemonUUID);
        buf.writeInt(this.newPokemon.getDex());
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.playerID = buf.func_179253_g();
        this.pokemonUUID = buf.func_179253_g();
        this.newPokemon = PixelmonSpecies.fromNationalDex(buf.readInt());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!PokemonEditorItem.checkPermission(player)) {
            return;
        }
        PlayerPartyStorage party = StorageProxy.getParty(this.playerID);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon == null) {
            pokemon = PokemonFactory.create(this.newPokemon).initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC_FORCEFUL).setUUID(this.pokemonUUID);
            party.add(pokemon);
        } else {
            pokemon.setSpecies(this.newPokemon, true);
            pokemon.initialize(InitializeCategory.SPECIES, InitializeCategory.INTRINSIC_FORCEFUL);
        }
        int slot = party.getSlot(pokemon);
        PokemonEditorItem.updateSinglePokemon(player, this.playerID, slot);
    }
}

