/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TrainerPartyStorage;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TrainerEditorScreen;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokemoneditor.UpdateEditedPokemonPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UpdateTrainerPokemonPacketPacket
extends UpdateEditedPokemonPacket {
    public int trainerID;

    public UpdateTrainerPokemonPacketPacket() {
    }

    public UpdateTrainerPokemonPacketPacket(Pokemon data) {
        super(data);
        this.trainerID = TrainerEditorScreen.currentTrainerID;
    }

    public UpdateTrainerPokemonPacketPacket(Pokemon data, int slot) {
        super(data, slot);
        this.trainerID = TrainerEditorScreen.currentTrainerID;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.trainerID);
        super.encode(buffer);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.trainerID = buffer.readInt();
        super.decode(buffer);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!NPCEditorItem.checkPermission((PlayerEntity)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.field_70170_p, this.trainerID, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer t = entityNPCOptional.get();
        TrainerPartyStorage storage = t.getPokemonStorage();
        UpdateTrainerPokemonPacketPacket.updatePokemon(this, player, storage);
        if (this.data != null) {
            t.updateTrainerLevel();
            storage.sendCacheToPlayer(player);
        }
    }
}

