/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.evolution;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class EvolutionResponsePacket
extends AbstractPixelmonPacket {
    private boolean accept;
    private UUID pokemonUUID;
    private EvolutionResponseMode mode;

    public EvolutionResponsePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public EvolutionResponsePacket(UUID pokemonUUID, boolean accept) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.accept = accept;
        this.mode = EvolutionResponseMode.MESSAGE;
    }

    public EvolutionResponsePacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.mode = EvolutionResponseMode.SPAWN_POKEMON;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.mode = EvolutionResponseMode.values()[buffer.readInt()];
        this.pokemonUUID = buffer.func_179253_g();
        if (this.mode == EvolutionResponseMode.MESSAGE) {
            this.accept = buffer.readBoolean();
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.mode.ordinal());
        buffer.func_179252_a(this.pokemonUUID);
        if (this.mode == EvolutionResponseMode.MESSAGE) {
            buffer.writeBoolean(this.accept);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.mode == EvolutionResponseMode.MESSAGE) {
            if (this.accept) {
                EvolutionQueryList.acceptQuery(context.getSender(), this.pokemonUUID);
            } else {
                EvolutionQueryList.declineQuery(context.getSender(), this.pokemonUUID);
            }
        } else {
            EvolutionQueryList.spawnPokemon(context.getSender(), this.pokemonUUID);
        }
    }

    static enum EvolutionResponseMode {
        MESSAGE,
        SPAWN_POKEMON;

    }
}

