/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdateDayCareHistoryPacket
extends AbstractPixelmonPacket {
    private List<PokemonBase> history = Lists.newArrayList();

    public UpdateDayCareHistoryPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public UpdateDayCareHistoryPacket(List<PokemonBase> history) {
        this();
        this.history.addAll(history);
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.history.size());
        for (PokemonBase pokemonBase : this.history) {
            PixelmonDataSerializers.POKEMON_BASE.func_187160_a(buffer, (Object)pokemonBase);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.history.add((PokemonBase)PixelmonDataSerializers.POKEMON_BASE.func_187159_a(buffer));
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party = ClientStorageManager.party;
        if (party == null) {
            return;
        }
        party.getDayCare().setHistory(this.history);
    }
}

