/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.client.gui.daycare.DayCareContainer;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.IsiHourglassItem;
import net.minecraft.data.BlockStateVariantBuilder;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class DayCareHourglassUsedPacket
extends AbstractPixelmonPacket {
    private int[] boxes;
    private int clicked;

    public DayCareHourglassUsedPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public DayCareHourglassUsedPacket(int clicked, int ... boxes) {
        this();
        this.clicked = clicked;
        this.boxes = boxes;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.clicked);
        buffer.writeInt(this.boxes.length);
        for (int box : this.boxes) {
            buffer.writeInt(box);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.clicked = buffer.readInt();
        int size = buffer.readInt();
        this.boxes = new int[size];
        for (int i = 0; i < size; ++i) {
            this.boxes[i] = buffer.readInt();
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        Container containerMenu = sender.field_71070_bA;
        if (!(containerMenu instanceof DayCareContainer)) {
            return;
        }
        ItemStack held = sender.field_71071_by.func_70445_o();
        if (!(held.func_77973_b() instanceof IsiHourglassItem)) {
            return;
        }
        IsiHourglassItem item = (IsiHourglassItem)held.func_77973_b();
        IsiHourglassItem.HourGlassType type = item.getType();
        DayCareEvent.HourGlassUsed.Pre pre = new DayCareEvent.HourGlassUsed.Pre(sender, StorageProxy.getParty(sender), held, (BlockStateVariantBuilder.ITriFunction<ServerPlayerEntity, Integer, int[], Boolean>)((BlockStateVariantBuilder.ITriFunction)type::handle));
        if (Pixelmon.EVENT_BUS.post((Event)pre)) {
            return;
        }
        boolean handle = (Boolean)pre.getHandler().apply((Object)sender, (Object)this.clicked, (Object)this.boxes);
        if (!handle) {
            return;
        }
        if (!sender.func_184812_l_()) {
            sender.field_71071_by.func_70445_o().func_190918_g(1);
            sender.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, sender.field_71071_by.func_70445_o()));
            sender.field_71071_by.func_70296_d();
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.HourGlassUsed.Post(sender, StorageProxy.getParty(sender), pre.getItem(), pre.getHandler()));
    }
}

