/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.daycare;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareBoxPacket;
import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AddToDayCarePacket
extends AbstractPixelmonPacket {
    private int boxId;
    private int slotOne;
    private int slotTwo;

    public AddToDayCarePacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public AddToDayCarePacket(int boxId, int slotOne, int slotTwo) {
        this();
        this.boxId = boxId;
        this.slotOne = slotOne;
        this.slotTwo = slotTwo;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.boxId);
        buffer.writeInt(this.slotOne);
        buffer.writeInt(this.slotTwo);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.boxId = buffer.readInt();
        this.slotOne = buffer.readInt();
        this.slotTwo = buffer.readInt();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        PlayerPartyStorage party = StorageProxy.getParty(context.getSender().func_110124_au());
        if (party == null) {
            return;
        }
        DayCareBox dayCareBox = party.getDayCare().getOrCreateBox(this.boxId).orElse(null);
        if (dayCareBox == null) {
            return;
        }
        Pokemon parentOne = party.get(this.slotOne);
        Pokemon parentTwo = party.get(this.slotTwo);
        if (parentOne == null || parentTwo == null || !Objects.equals(party.getDayCare().getParentOne(), parentOne.getUUID()) || !Objects.equals(party.getDayCare().getParentTwo(), parentTwo.getUUID())) {
            return;
        }
        DayCareEvent.PrePokemonAdd preEvent = new DayCareEvent.PrePokemonAdd(party.getPlayer(), party, parentOne, parentTwo, party.getDayCare().getEgg());
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        party.set(this.slotOne, null);
        party.set(this.slotTwo, null);
        dayCareBox.addDayCare(preEvent.getParentOne(), preEvent.getParentTwo(), preEvent.getChildCreated());
        this.reply(context, new UpdateDayCareBoxPacket(dayCareBox));
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostPokemonAdd(party.getPlayer(), party, preEvent.getParentOne(), preEvent.getParentTwo(), preEvent.getChildCreated()));
    }
}

