/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.storage.PCBox;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ClientInitializePCPacket
extends AbstractPixelmonPacket {
    private PCStorage storage;

    public ClientInitializePCPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ClientInitializePCPacket(PCStorage storage) {
        super(PacketDirection.PLAY_CLIENT, true);
        Preconditions.checkNotNull((Object)storage);
        this.storage = storage;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeLong(this.storage.uuid.getMostSignificantBits());
        buffer.writeLong(this.storage.uuid.getLeastSignificantBits());
        buffer.writeShort(this.storage.getBoxCount());
        buffer.writeShort(this.storage.getLastBox());
        for (int i = 0; i < this.storage.getBoxCount(); ++i) {
            PCBox box = this.storage.getBox(i);
            buffer.func_180714_a(box.getName() == null ? "" : box.getName());
            buffer.func_180714_a(box.getWallpaper() == null ? "" : box.getWallpaper());
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.storage = new PCStorage(new UUID(buf.readLong(), buf.readLong()), buf.readShort());
        this.storage.shouldSendUpdates = false;
        this.storage.setLastBox(buf.readShort());
        for (int i = 0; i < this.storage.getBoxCount(); ++i) {
            PCBox box = this.storage.getBox(i);
            box.setName(buf.func_218666_n());
            box.setWallpaper(buf.func_218666_n());
            box.hasChangedClientSide = false;
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        if (this.storage.uuid.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            this.storage.playerUUID = this.storage.uuid;
        }
        ClientStorageManager.pcs.put(this.storage.uuid, this.storage);
        if (ClientStorageManager.openPC == null || ClientStorageManager.openPC.getBoxCount() == 0) {
            ClientStorageManager.openPC = this.storage;
        }
    }
}

