/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class StartSpectatePacket
extends AbstractPixelmonPacket {
    private BattleType battleType = BattleType.SINGLE;
    private UUID uuid;

    public StartSpectatePacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public StartSpectatePacket(UUID spectatedPlayer, BattleType battleType) {
        super(PacketDirection.PLAY_CLIENT);
        this.battleType = battleType;
        this.uuid = spectatedPlayer;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.battleType = BattleType.values()[buf.readInt()];
        this.uuid = buf.func_179253_g();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.battleType.ordinal());
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.spectatingUUID = this.uuid;
        context.enqueueWork(() -> ClientProxy.battleManager.startSpectate(this.battleType));
    }
}

