/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class SetAllBattlingPokemonPacket
extends AbstractPixelmonPacket {
    private PixelmonClientData[] allPokemon;
    private boolean useOldHealthValues;

    public SetAllBattlingPokemonPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public SetAllBattlingPokemonPacket(PixelmonClientData[] allPokemon, boolean useOldHealthValues) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.allPokemon = allPokemon;
        this.useOldHealthValues = useOldHealthValues;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        int numPokemon = this.allPokemon.length;
        for (PixelmonClientData d : this.allPokemon) {
            if (d != null) continue;
            --numPokemon;
        }
        buffer.writeByte(numPokemon);
        for (PixelmonClientData d : this.allPokemon) {
            if (d == null) continue;
            d.encodeInto(buffer);
        }
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.allPokemon = new PixelmonClientData[buffer.readByte()];
        for (int i = 0; i < this.allPokemon.length; ++i) {
            this.allPokemon[i] = new PixelmonClientData();
            this.allPokemon[i].decodeFrom(buffer);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.setFullTeamData(this.allPokemon, this.useOldHealthValues);
    }
}

