/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonClientData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class DynamaxPacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private boolean gigantamax;

    public DynamaxPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public DynamaxPacket(UUID pokemonUUID, boolean gigantamax) {
        super(PacketDirection.PLAY_CLIENT);
        this.pokemonUUID = pokemonUUID;
        this.gigantamax = gigantamax;
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.func_179252_a(this.pokemonUUID);
        buf.writeBoolean(this.gigantamax);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pokemonUUID = buf.func_179253_g();
        this.gigantamax = buf.readBoolean();
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ClientProxy.battleManager.gigantamax = this.gigantamax;
        ClientProxy.battleManager.dynamax = this.pokemonUUID;
        PixelmonClientData pokemon = ClientProxy.battleManager.getPokemon(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        pokemon.dynamax = this.pokemonUUID != null ? (this.gigantamax ? 2 : 1) : 0;
    }
}

