/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnumBattleQueryResponse;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class AcceptDeclineBattlePacket
extends AbstractPixelmonPacket {
    private EnumBattleQueryResponse response;
    private int queryID;

    public AcceptDeclineBattlePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public AcceptDeclineBattlePacket(int queryID, EnumBattleQueryResponse response) {
        super(PacketDirection.PLAY_SERVER, true);
        this.queryID = queryID;
        this.response = response;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.queryID = buffer.readInt();
        this.response = EnumBattleQueryResponse.getFromOrdinal(buffer.readInt());
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.queryID);
        buffer.writeInt(this.response.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        BattleQuery query = BattleQuery.getQuery(this.queryID);
        if (query == null) {
            return;
        }
        ServerPlayerEntity player = context.getSender();
        player.func_143004_u();
        switch (this.response) {
            case Decline: {
                query.declineQuery(player);
                break;
            }
            case Accept: 
            case Rules: {
                query.acceptQuery(player, this.response);
                break;
            }
            case Change: {
                query.changeRules(player);
                break;
            }
        }
    }
}

