/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractMovesEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class UpdatePixelmonMovementPacket
extends AbstractPixelmonPacket {
    private int id;
    private int takeOffTicks;
    private float lastSpeed;
    private float speed;
    private float rotationPitch;
    private float rotationYaw;
    private float strafe;
    private float strafeUp;
    private double posX;
    private double posY;
    private double posZ;
    private Vector3d targetPosition;
    private boolean hasTargetPos = false;

    public UpdatePixelmonMovementPacket() {
        super(PacketDirection.PLAY_CLIENT);
    }

    public UpdatePixelmonMovementPacket(AbstractMovesEntity pixelmon) {
        super(PacketDirection.PLAY_CLIENT);
        this.id = pixelmon.func_145782_y();
        this.speed = pixelmon.getMoveMultiplier();
        this.strafe = pixelmon.field_70702_br;
        this.strafeUp = pixelmon.getStrafeUpDown();
        this.targetPosition = pixelmon.getTargetPosition();
        this.hasTargetPos = this.targetPosition != null;
        this.takeOffTicks = pixelmon.takeOffTicks;
        this.posX = pixelmon.func_226277_ct_();
        this.posY = pixelmon.func_226278_cu_();
        this.posZ = pixelmon.func_226281_cx_();
        this.rotationPitch = pixelmon.field_70125_A;
        this.rotationYaw = pixelmon.field_70177_z;
        this.lastSpeed = pixelmon.lastSpeed;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.id = buffer.readInt();
        this.speed = buffer.readFloat();
        this.strafe = buffer.readFloat();
        this.strafeUp = buffer.readFloat();
        this.takeOffTicks = buffer.readInt();
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
        this.rotationPitch = buffer.readFloat();
        this.rotationYaw = buffer.readFloat();
        this.lastSpeed = buffer.readFloat();
        if (buffer.readBoolean()) {
            this.hasTargetPos = true;
            this.targetPosition = new Vector3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.id);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.strafe);
        buffer.writeFloat(this.strafeUp);
        buffer.writeInt(this.takeOffTicks);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.writeFloat(this.rotationPitch);
        buffer.writeFloat(this.rotationYaw);
        buffer.writeFloat(this.lastSpeed);
        buffer.writeBoolean(this.hasTargetPos);
        if (this.hasTargetPos) {
            buffer.writeDouble(this.targetPosition.field_72450_a);
            buffer.writeDouble(this.targetPosition.field_72448_b);
            buffer.writeDouble(this.targetPosition.field_72449_c);
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.id);
        if (!(entity instanceof AbstractMovesEntity)) {
            return;
        }
        AbstractMovesEntity pixelmon = (AbstractMovesEntity)entity;
        if (pixelmon.func_184207_aI() && pixelmon.func_184179_bs() == Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        if (this.hasTargetPos) {
            pixelmon.setMovementTarget(this.targetPosition);
        }
        pixelmon.setMoveMultiplier(this.speed);
        pixelmon.field_70702_br = this.strafe;
        pixelmon.setStrafeUpDown(this.strafeUp);
        pixelmon.takeOffTicks = this.takeOffTicks;
        pixelmon.field_70125_A = this.rotationPitch;
        if (Math.abs(pixelmon.func_226277_ct_() - this.posX) > 1.0 || Math.abs(pixelmon.func_226278_cu_() - this.posY) > 1.0 || Math.abs(pixelmon.func_226281_cx_() - this.posZ) > 1.0) {
            pixelmon.func_70107_b(this.posX, this.posY, this.posZ);
        }
        pixelmon.field_70125_A = this.rotationPitch;
        pixelmon.field_70177_z = this.rotationYaw;
        pixelmon.lastSpeed = this.lastSpeed;
        if (!pixelmon.lastFlyingState) {
            pixelmon.takeOff();
            pixelmon.lastFlyingState = true;
        }
    }
}

