/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetMegaItemPacket
extends AbstractPixelmonPacket {
    private EnumMegaItem megaItem;

    public SetMegaItemPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public SetMegaItemPacket(EnumMegaItem megaItem) {
        super(PacketDirection.PLAY_SERVER);
        this.megaItem = megaItem;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.megaItem = EnumMegaItem.values()[buffer.readInt()];
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.megaItem.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        if (storage.canEquipMegaItem() && (this.megaItem.canEvolve() && storage.getMegaItemsUnlocked().canMega() || this.megaItem.canDynamax() && storage.getMegaItemsUnlocked().canDynamax() || this.megaItem == EnumMegaItem.None)) {
            storage.setMegaItem(this.megaItem, false);
        }
    }
}

