/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.google.common.base.Preconditions;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetHeldItemPacket
extends AbstractPixelmonPacket {
    private StoragePosition position;
    private UUID pokemon;
    private Item item;

    public SetHeldItemPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SetHeldItemPacket(StoragePosition position, UUID pokemon) {
        super(PacketDirection.PLAY_SERVER, true);
        this.position = position;
        this.pokemon = pokemon;
    }

    public void setItem(Item item) {
        this.item = item == null ? Items.field_190931_a : item;
    }

    @Override
    public void encode(PacketBuffer buf) {
        this.position.encode((ByteBuf)buf);
        buf.writeBoolean(this.pokemon != null);
        if (this.pokemon != null) {
            buf.writeLong(this.pokemon.getMostSignificantBits());
            buf.writeLong(this.pokemon.getLeastSignificantBits());
        }
        buf.writeBoolean(this.item != null);
        if (this.item != null) {
            buf.writeInt(Item.func_150891_b((Item)this.item));
        }
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.position = StoragePosition.decode((ByteBuf)buf);
        if (buf.readBoolean()) {
            this.pokemon = buf.func_179253_g();
        }
        this.item = buf.readBoolean() ? Item.func_150899_d((int)buf.readInt()) : null;
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        PokemonStorage storage = StorageProxy.getStorage(player, this.position);
        if (!storage.validate(this.position, this.pokemon)) {
            storage.notifyListener(player, this.position, storage.get(this.position), new EnumUpdateType[0]);
            return;
        }
        if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
            return;
        }
        PlayerInventory inventory = player.field_71071_by;
        Pokemon pokemon = storage.get(this.position);
        Preconditions.checkArgument((pokemon != null ? 1 : 0) != 0, (Object)"The pok\u00e9mon cannot be null since we've already validated it");
        ItemStack newHeldItem = ItemStack.field_190927_a;
        ItemStack currentItem = inventory.func_70445_o().func_77946_l();
        ItemStack giveItem = null;
        if (player.func_184812_l_()) {
            newHeldItem = this.item == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)this.item, 1);
        } else {
            ItemStack oldItem = pokemon.getHeldItem();
            if (oldItem.func_190926_b()) {
                if (!currentItem.func_190926_b()) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    newHeldItem = singleItem;
                    currentItem.func_190918_g(1);
                }
            } else if (currentItem.func_190926_b()) {
                currentItem = oldItem;
                newHeldItem = ItemStack.field_190927_a;
            } else if (ItemStack.func_179545_c((ItemStack)oldItem, (ItemStack)currentItem) && ItemStack.func_77970_a((ItemStack)oldItem, (ItemStack)currentItem)) {
                currentItem.func_190917_f(1);
            } else {
                ItemStack singleItem = currentItem.func_77946_l();
                singleItem.func_190920_e(1);
                newHeldItem = singleItem;
                if (currentItem.func_190916_E() <= 1) {
                    currentItem = oldItem;
                } else {
                    currentItem.func_190918_g(1);
                    giveItem = oldItem;
                }
            }
        }
        if (newHeldItem.func_190926_b()) {
            newHeldItem = ItemStack.field_190927_a;
        }
        inventory.func_70437_b(currentItem);
        if (giveItem != null && !inventory.func_70441_a(giveItem)) {
            player.func_71019_a(giveItem, false);
        }
        pokemon.setHeldItem(newHeldItem);
    }
}

